<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SocialController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProductController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('/login', 'AuthController@Login');
Route::post('/api-login', 'AuthController@ApiLogin');
Route::post('/googleLogin', 'AuthController@googleLogin');
Route::post('/faceIdLogin', 'AuthController@faceIdLogin');
Route::post('/forgot', 'AuthController@Forgot');
Route::post('/recover', 'AuthController@Recover');

Route::post('/delivery_status_log', 'OrderController@DeliveryStatusLog');

Route::post('/checkout-webhooker', 'OrderController@AfterCheckoutSquare');
Route::post('admin/orders/{orderId}/status', 'AdminController@UpdateOrderStatus');
Route::post('admin/orders/{orderId}/sendQueueEmails', 'AdminController@sendQueueEmails');
Route::get('admin/sendCronJobQueueEmails', 'AdminController@sendCronJobQueueEmails');
Route::get('getTraderJson/{companyName}', 'DeliveryController@getTraderJson');
Route::get('testmail', 'DeliveryController@testmail');
Route::post('admin/chat/sendOfflineChatEmail', 'AdminController@sendOfflineChatEmail');
Route::get('/etsy_integration', 'OrderController@Etsy');
Route::get('/etsy_update','OrderController@etsyOrderSync');
Route::get('current_shop_details','ShopifyIntegrationController@getCurrentShopIntegrationDetails');
/* Route::get('/update_purchasing_cron','OrderController@updatePurchasingCron'); */
Route::post('/update_tracking_details', 'AdminController@updateReceivingPackageTrackingDetails');
Route::post('/update_tracking_aftership_webhook', 'AdminController@updateOrderTrackingDetailWebhook');
Route::get('/add_tracking_aftership/{id}', 'AdminController@addTrackingNumberInAfterShip');
Route::get('/pdf/download', 'ShipStationController@downloadPdfFile');
Route::post('/upload_delivery_photo', 'DeliveryController@createDelivery');
Route::post('/updateDeliveryPhoto', 'DeliveryController@updateDeliveryPhoto');
Route::post('/updateHandDeliveryMail', 'DeliveryController@updateHandDeliveryMail');
Route::get('/admin/vendors/list', 'AdminController@GetVendorsList');
Route::get('/admin/vendors/list/name', 'AdminController@GetVendorsListName');

Route::middleware('auth:api')->group(function () {
    Route::get('/user', 'AuthController@User');
    Route::get('admin/users/{userId}/details', 'AdminController@UserDetail');
    Route::post('admin/users/{userId}/update', 'AdminController@UserUpdate'); 
    Route::post('admin/users/{userId}/updateProfilePhoto', 'AdminController@updateProfilePhoto');
    Route::group(['prefix' => 'messages'], function () {
        Route::get('/', ['as' => 'messages', 'uses' => 'MessagesController@index']);
        //Route::get('create', ['as' => 'messages.create', 'uses' => 'MessagesController@create']);
        Route::get('order_id/{order_id}', ['as' => 'messages.open_by_order', 'uses' => 'MessagesController@showByOrder']);
        Route::post('thread_id/{thread_id}', ['as' => 'messages.store_order_message', 'uses' => 'MessagesController@storeOrderMessage']);
        Route::post('/new_message', ['as' => 'messages.store', 'uses' => 'MessagesController@store']);
        Route::get('{id}', ['as' => 'messages.show', 'uses' => 'MessagesController@show']);
        Route::put('{id}', ['as' => 'messages.update', 'uses' => 'MessagesController@update']);
    });



    Route::prefix('admin')->middleware('role:Admin,Etsy_Admin,Sales,Trader,Production')->group(function () { 

        Route::prefix('ai')->group(function(){
            Route::resource('threads', 'AIChatController');
            Route::post('reply_to_thread/{threadID}','AIChatController@createMessage'); 
        });
        
        Route::resource('product_groups', 'ProductGroupController');
        Route::resource('products', 'ProductController');
        Route::get('shopify_sync','OrderController@shopifyOrderSync');
        Route::post('change_product_status','ProductController@changeProductStatus');
        Route::post('sync_products','ShopifyIntegrationController@syncProducts');
        Route::resource('shopify_integrations', 'ShopifyIntegrationController');
        Route::resource('shopify_integrations.locations','ShopifyLocationController')->parameters([
            'shopify_integrations' => 'shopID'
        ]);
        Route::get('user_orders_from_order_id/{orderID}','OrderController@getCustomerOrdersFromOrderID');
        Route::post('update_purchasing_shipping/{orderID}', 'AdminController@updatePurchasingShipping');
        Route::post('purchase_ss', 'AdminController@postSSActiveWearOrder');
        /* ss_tracker Disabled  - Not used in any place */
        //Route::get('ss_tracker', 'AdminController@GetTrackingDetailsSS');
        Route::get('scp_groups', 'AdminController@GroupSearcher');


        Route::post('product/{productID}/duplicate', 'ProductController@duplicate');

        Route::get('get_order_details/{orderID}','AdminController@GetTrackingDetails');
        Route::get('get_order_tracking_details/{orderID}','AdminController@GetOrderTrackingDetails');
        Route::get('get_tracking_details/{orderID}','AdminController@GetReceivingPackageTrackingDetails');
      

        Route::post('printers/create', 'AdminController@CreatePrinter');
        Route::post('printers/{id}/update', 'AdminController@UpdatePrinter');
        Route::post('printers/{id}/updateFaceId', 'AdminController@UpdatePrinterFaceId');
        Route::post('printer-break', 'AdminController@printerBreak');
        Route::post('printers/{id}/getPrintersOrderList', 'AdminController@GetPrintersOrderList');
        Route::post('printers/{id}/getPrintersOrderListId', 'AdminController@GetPrintersOrderListId');
        Route::post('printers/{printerId}/{id}/update', 'AdminController@UpdatePrintersIdInOrdersTable');
        Route::post('trader/{printerId}/{id}/update', 'AdminController@UpdatePrintersIdInOrdersTable');
        Route::post('admin-trader/{userId}/{id}/update', 'AdminController@UpdatePrintersIdInOrderForTrader');
        Route::post('worker/{printerId}/{id}/update', 'AdminController@updateWorkingOrderId');
        Route::post('updateDeploymentCartQueue/update', 'AdminController@updateDeploymentCartQueue');
        Route::get('printers/{id}/delete', 'AdminController@DeletePrinter');
        Route::get('returnDeployment/{id}/delete', 'AdminController@returnDeployment');
        Route::get('clearQueue', 'AdminController@clearQueue');
        Route::post('resources/create', 'AdminController@CreateResource');
        Route::post('vendor/create', 'AdminController@CreateVendor');
        Route::post('resources/{id}/update', 'AdminController@UpdateResource');
        Route::post('vendor/{id}/update', 'AdminController@UpdateVendor');
        Route::post('resources/{id}/isPrimary', 'AdminController@UpdateResourceIsPrimary');
        Route::post('vendor/{id}/{field}', 'AdminController@UpdateVendorSubFields');
        Route::get('resources/{id}/delete', 'AdminController@DeleteResource');
        Route::get('vendor/{id}/delete', 'AdminController@DeleteVendor');
        Route::post('resources/{resourceId}/{id}/update', 'AdminController@UpdateResourceIdInOrdersTable');
        Route::post('order-type/create', 'AdminController@orderTypeCreate');
        Route::get('users/list', 'AdminController@GetUsersList');
        Route::get('active-users/list', 'AdminController@GetAllActiveUsersList');
        Route::post('users/create', 'AdminController@CreateUser');
 

 
        Route::post('users-order-type/{userId}/update', 'AdminController@OrderTypeUpdate');
        Route::get('users-order-type/list', 'AdminController@OrderTypeList');
        Route::get('users/{userId}/status', 'AdminController@UserStatus');
        Route::get('users/{userId}/updateDefaultUserId', 'AdminController@updateDefaultUserId');
        Route::get('users/{userId}/delete', 'AdminController@DeleteUser');
        Route::get('users/{userId}/enable', 'AdminController@EnableUser');
        Route::post('trader-user/{userId}/update', 'AdminController@TraderUpdate');
        Route::post('admin/{printerId}/{id}/update', 'AdminController@UpdateTraderOrderToAdmin');

        Route::get('orders/{orderId}/shipping', 'AdminController@Shipping');
        Route::get('orders/{orderId}/issue', 'AdminController@OrderIssue');

        Route::post('orders/{orderId}/assign-printer', 'AdminController@OrderAssignPrinter');
        Route::get('orders/count/{userId}', 'DashboardController@countTotalByStatus');
        Route::get('userDetails/{userId}', 'DashboardController@getDefaultUserDetails');
        Route::get('timeline/activity/all/{userId}', 'DashboardController@TimelineActivity');
        Route::post('timeline/activity/search', 'DashboardController@TimelineActivitySearch');
        Route::get('getChartDetails', 'DashboardController@getChartDetails');
        Route::get('/product_list','OrderController@getStyleColorProduct');
        Route::get('/product_list_exact','OrderController@getSCPExact');
        Route::get('resources/shipping/{id}/delete', 'AdminController@DeleteResourceShipping');

    });

    Route::prefix('admin')->middleware('role:Admin,Etsy_Admin,Sales,Trader,Production')->group(function () {
        Route::get('printers/list', 'AdminController@GetPrintersList');
        Route::get('resources/list', 'AdminController@GetResourcesList');
        Route::get('trader/list', 'AdminController@GetTraderList');

        Route::get('resources_orders/{status}/list', 'AdminController@GetResourcesAndOrdersList');
        Route::get('printers_orders/{status}/list', 'AdminController@GetPrintersAndOrdersList');
        Route::post('printers_analytics/list', 'AdminController@GetPrintersListForAnalytics');
        Route::get('trader_orders/{status}/list', 'AdminController@GetTraderAndOrdersList');
        Route::get('trader_resource/list', 'AdminController@GetTraderAndResourceList');
        Route::get('traderAssignOrderToAdmin/{status}/list', 'AdminController@traderAssignOrderToAdmin');
        Route::get('GetPrintersAndOrdersListInProduction', 'AdminController@GetPrintersAndOrdersListInProduction');
        Route::get('getDeploymentById/{id}', 'AdminController@getDeploymentById');
        Route::post('getDeploymentByIdList', 'AdminController@getDeploymentByIdList');
        Route::get('getDeploymentList', 'AdminController@getDeploymentList');
        Route::post('updateDeployment/{id}', 'AdminController@updateDeployment');
        Route::resource('past_labels', 'LabelController');
    });


    Route::prefix('customer')->middleware('role:Customer')->group(function () {
        Route::get('orders/production', 'CustomerController@GetProductionOrder');
        Route::get('orders/completed', 'CustomerController@GetCompletedOrder');
        Route::get('orders/{orderID}/delete', 'CustomerController@DeleteCustomerOrder');
    });

    Route::prefix('production')->middleware('role:Production')->group(function () {
        Route::get('orders/list', 'ProductionController@GetProductionOrders');
    });

    Route::prefix('sales')->middleware('role:Sales')->group(function () {
        Route::get('orders/list', 'SalesController@GetOrdersList');
    });

    Route::post('invoice/check/{ids}', 'OrderController@InvoiceCheckSquare');
    Route::post('invoice/updatePayment/{id}', 'OrderController@squareupdatePayment');
    Route::post('invoice/updateRemainder/{id}', 'OrderController@squareUpdateRemainder');
    Route::post('invoice/updatePayment/{id}', 'OrderController@squareUpdatePayment');
    Route::post('start-date/{id}', 'OrderController@assignStartDate');

    Route::get('/users/list', 'AuthController@GetCustomerList');
    Route::get('/users/GetCustomerListByWhoOrdered', 'AuthController@GetCustomerListByWhoOrdered');
    Route::get('/sales/list', 'AuthController@GetSaleList');
    Route::post('/order', 'OrderController@Create');
    Route::get('/orders/list', 'OrderController@OrdersList');

    Route::post('/createprintjob', 'OrderController@CreatePrintJobs');
    
    Route::get('/email/unread', 'EmailController@getUnreadEmail');

    Route::get('/v2/orders/list', 'OrderController@OrdersListV2');
    Route::get('/updateRequiredList', 'DashboardController@updateRequiredList');
    Route::get('/calenderList', 'DashboardController@calenderList');
    Route::get('/orderListLite', 'DashboardController@orderListLite');
    Route::get('/orderListWithDelivery', 'DeliveryController@orderListWithDelivery');

    Route::get('/printerOrderList', 'DashboardController@printerOrderList');
    Route::get('/userEmailTags', 'DashboardController@userEmailTags');
    Route::get('/emailTags/{id}', 'DashboardController@emailTags');
    Route::get('/emailThreadTags/{id}', 'DashboardController@emailThreadTags');
    Route::post('/createEmailTag', 'DashboardController@createEmailTag');
    Route::post('/createUserEmailTag', 'DashboardController@createUserEmailTag');
    Route::post('/deleteEmailTag', 'DashboardController@deleteEmailTag');


    Route::get('/v2/unassigned/resourceList', 'OrderController@unassignedResourceList');

    Route::get('/orders/{orderID}/delete', 'OrderController@DeleteOrder');

    Route::get('/orders/{orderID}/get-labels', 'OrderController@getAllLabels');

    Route::post('/orders/{orderID}/update', 'OrderController@UpdateOrder');
    Route::post('/orders/{orderID}/upload-film', 'OrderController@UploadFilm');
    Route::post('/orders/{orderID}/art-file', 'OrderController@UploadArtFile');
    Route::get('/orders/{orderID}/file/{fileID}', 'OrderController@DeleteFile');

    Route::post('/orders/{orderID}/updateBoxWeight', 'OrderController@updateBoxWeight');
    Route::post('/orders/{orderID}/updatePackageDetails', 'OrderController@updatePackageDetails');
    
    Route::post('/orders/{orderID}/shipping_label', 'OrderController@CreateShippingLabel');
    Route::post('/orders/{orderID}/resource_sending', 'OrderController@SendToOutsideResource');

    Route::post('/create_qr_code/{orderID}/{type}', 'OrderController@SaveQRCode');


    Route::get('/events', 'AuthController@GetEventsList');
    Route::post('/events', 'AuthController@CreateEvent');
    Route::get('/events/{id}/delete', 'AuthController@DeleteEvent');


    Route::get('/carriers', 'ShipStationController@GetCarriersList');
    Route::get('/packages/{carrier_code}', 'ShipStationController@GetPackagesList');
    Route::post('/generate_label/{orderID}', 'ShipStationController@GenerateLabel');
    Route::post('/resourceShippingLabel/{orderID}', 'ShipStationController@ResourceShippingLabel');
    Route::post('/savePickUpDetails/{orderID}', 'ShipStationController@savePickUpDetails');
    Route::post('/sendShippingResourceEmail/{orderID}', 'ShipStationController@sendShippingResourceEmail');
    Route::get('/getResourceShippingLabel/{orderID}', 'ShipStationController@GetResourceLabels');

    Route::post('/update-password', 'AuthController@UpdatePassword');
    Route::post('/update-profile', 'AuthController@UpdateProfile');
    Route::post('/update-shipping', 'AuthController@UpdateShipping');
    Route::post('/addpartialtimestamp', 'OrderController@Addpartialtimestamp');
    Route::get('/viewpartialtimestamp/{orderID}', 'OrderController@Viewpartialtimestamp');
    Route::get('/OrdersRecevingListV2', 'OrderController@OrdersRecevingListV2');
});

Route::post('/usergalleryimage', 'UsergalleryController@UsergalleryImage');
Route::post('/saveEmailImageToGallery', 'UsergalleryController@saveEmailImageToGallery');
Route::post('/previewEmailAttachedImage', 'UsergalleryController@previewEmailAttachedImage');
Route::get('/previewImage/{downloadId}/{token}/{fileName}', 'UsergalleryController@previewImage');
Route::get('/previewThumbnailImage/{downloadId}/{token}/{fileName}', 'UsergalleryController@previewThumbnailImage');
Route::get('/image/{id}/{size}', 'UsergalleryController@generateImage');
Route::get('/otherImage', 'UsergalleryController@generateOtherImage');

Route::post('/usergallerydelete', 'UsergalleryController@UsergallerydeleteImage');

Route::get('/usergallery', 'UsergalleryController@GetUsergalleryImage');
Route::get('/saveImage', 'UsergalleryController@saveImage');

Route::get('/orders/{orderID}', 'OrderController@GetOrderDetail');
Route::get('/getprintjobs/{type}', 'OrderController@GetPrintJobs');
Route::get('/deleteprintjob', 'OrderController@DeletePrintJob');
Route::get('/redirect', 'SocialController@redirect');
Route::get('/callback', 'SocialController@callback');

Route::post('/useremailcontact', 'UseremailcontactController@addEmailcontact');
Route::get('/getuseremailcontact', 'UseremailcontactController@GetEmailcontact');

// OBS
Route::post('/userChatgalleryimage', 'UsergalleryController@saveChatImageToGallery');
Route::get('/getorders/{orderID}', 'OrderController@GetOrderDetails');

//Testing
Route::get('/resource/{orderID}', 'ShipStationController@getResourcUserDetails');
