<?php

namespace App\Http\Controllers;

use App\Mail\OrderCompleted;
use App\Mail\OrderInCompleted;
use App\Mail\OrderProduction;
use App\Mail\OrderShipmentDelivered;
use App\Mail\ResourceShippingEmailNewlyAssigned;
use App\Models\AccessCode;
use App\Models\Misc;
use App\Models\Order;
use App\Models\OrderArt;
use App\Models\OrderMeta;
use App\Models\OrderDetails;
use App\Models\UserOrderType;
use App\Models\PastLabels;
use App\Models\Printer;
use App\Models\Resource;
use App\Models\User;
use App\Models\Vendor;
use App\Models\OrderDeployment;
use App\Models\ActivityNotif;
use App\Models\OrderEmailQueue;
use App\Models\IssueWithOrder;
use App\Mail\ResourceEmail;
use App\Mail\OfflineChatEmail;
use App\Mail\ResourcePickUpEmail;
use App\Mail\ResourceShippingEmail;
use App\Mail\VendorOrderPlacementMail;
use App\Models\ShopifyLocation;
use App\Models\SiteSettings;
use App\Models\ShopifyIntegration;
use App\Models\ResourceShipping;
use App\Models\PrinterTimeLog;
use Illuminate\Support\Str;
use App\Models\StyleColorProduct;
use App\Models\ScpGroup;
use Cerbero\JsonParser\JsonParser;
use function Cerbero\JsonParser\parseJson;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Mail;
use Twilio;
use Validator;
use Cookie;
use GuzzleHttp as Guzzle;   
use Config;

class AdminController extends Controller
{

    public function resize_crop_image($max_width, $source_file, $dst_dir ){
        $imgsize = getimagesize($source_file);
        $width = $imgsize[0];
        $height = $imgsize[1];
        $mime = $imgsize['mime'];
    
        switch($mime){
            case 'image/gif':
                $image_create = "imagecreatefromgif";
                $image = "imagegif";
                break;
    
            case 'image/png':
                $image_create = "imagecreatefrompng";
                $image = "imagepng";
                $quality = 7;
                break;
    
            case 'image/jpeg':
                $image_create = "imagecreatefromjpeg";
                $image = "imagejpeg";
                $quality = 80;
                break;
    
            default:
                return false;
                break;
        }
        $new_height = abs($max_width * $height / $width);
        $dst_img = imagecreatetruecolor($max_width, $new_height);
        $src_img = @$image_create($source_file);
                
        imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $max_width, $new_height, $width, $height); 
 
        if($image == "imagegif"){
            $image($dst_img, $dst_dir);
        }else{
            $image($dst_img, $dst_dir, $quality);
        }
    
        if($dst_img)imagedestroy($dst_img);
        if($src_img)imagedestroy($src_img);
    }

    
    public function resize_crop_image_png($max_width, $source_file, $dst_dir ){
        $imgsize = getimagesize($source_file);
        $width = $imgsize[0];
        $height = $imgsize[1];
        $mime = $imgsize['mime'];

        switch($mime){
            case 'image/gif':
                $image_create = "imagecreatefromgif";
                $image = "imagegif";
                break;
    
            case 'image/png':
                $image_create = "imagecreatefrompng";
                $image = "imagepng";
                $quality = 7;
                break;
    
            case 'image/jpeg':
                $image_create = "imagecreatefromjpeg";
                $image = "imagejpeg";
                $quality = 80;
                break;
    
            default:
                return false;
                break;
        }
    
        $new_height = abs($max_width * $height / $width);
        $dst_img = imagecreatetruecolor($max_width, $new_height);
        $src_img = @$image_create($source_file);
                
        imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $max_width, $new_height, $width, $height); 
 
        imagepng($dst_img, $dst_dir, 7);
    
        if($dst_img)imagedestroy($dst_img);
        if($src_img)imagedestroy($src_img);
    }
    
    public function updateEtsyTrackingData($orderID, $trackingDetails){
        //test to see that the refresh token works
        $refreshToken = @SiteSettings::getValue('last_refresh_token_used');
        $client = new Guzzle\Client([
            'verify' => false,
            'headers' => [
                'x-api-key' => env('ETSY')
            ]
        ]);
        if($refreshToken !== null){
            try {
                $refreshTokenTester = $client->post("https://api.etsy.com/v3/public/oauth/token",[
                    'form_params' => [
                        'grant_type' => 'refresh_token',
                        'client_id' => env('ETSY'),
                        'refresh_token' => $refreshToken
                    ]
                ]);
                $accessTokenData = json_decode($refreshTokenTester->getBody()->getContents());
                $client = new Guzzle\Client([
                    'verify' => false,
                    'headers' => [
                        'x-api-key' => env('ETSY')
                    ]
                ]);
                $order = Order::where(['id' => $orderID])->first();
                $orderMeta = OrderMeta::where(['order_id' => $orderID])->first();
                $etsyData = json_decode($orderMeta->etsy_metadata);
                $updateTrackingData = $client->post('https://openapi.etsy.com/v3/application/shops/'. env('ETSY_SHOP_ID') .'/receipts/'. $etsyData->receipt_id .'/tracking',[
                    'form_params' => $trackingDetails,
                    'headers' => [
                        'Authorization' => 'Bearer ' . $accessTokenData->access_token,
                        'x-api-key' => env('ETSY')
                    ] 
                ]);
                return json_decode($updateTrackingData->getBody()->getContents());
            }catch(\Exception $e){
                return $e->getMessage();
            }
        }
    }

    /* code Start */
    public function GetTrac(Request $request){
        $status = false;
        $error = '';

        try {

            if(preg_match("#^ss_po_#",$request->property)){
                OrderMeta::where(['order_id' => $request->get('id')])->update([$request->property => $request->get('value')]);
            }            

            $status = true;

        }catch(\Exception $e){
            $error = $e->getMessage();
        }

        return compact('status','error');
    }

    public function updateSS(Request $request){

        $json = JsonParser::parse(env('APP_URL').'/products.json')->pointer('/products/0/sku');

        foreach ($json as $key => $value) {
            echo $value;
        }
        
    }

    public function updatePurchasingShipping(Request $request, $orderID){

        $status = false;
        $data = [];
        $error = '';

        //check if there's an order/order meta for the order

        try {
            $metaDetails = OrderMeta::where(['order_id' => $orderID])->first();

            $column = '';

            switch($request->post('column')){
                case "invoice_number":
                    $column = 'purchasing_invoice';
                break;
                case "tracking_number":
                    $column = 'purchasing_tracking';
                break;
                case "order_number":
                    $column = 'purchasing_ordering';
                break;
            }

            if($metaDetails === null){
                //first one
                $purchasingData = ['data' => [$request->post('value'),'','']];
            }else{
                //get the index and data
                if(!isset($metaDetails->{$column})){
                    $purchasingData = (object) ['data' => ['','','']];
                }else{
                    $purchasingData = (object) $metaDetails->{$column};
                }

                $purchasingData->data[(intval($request->get('num'))-1)] = $request->get('value');
            }

            if($request->get('value') == '' && !empty($purchasingData->tracking_status)){
                $purchasingData->tracking_status[(intval($request->get('num'))-1)] = '';
            }

            OrderMeta::updateOrInsert(
                ['order_id' => $orderID],
                [$column => json_encode($purchasingData)]
            );

            $data = $purchasingData;

            $status = true;

            if($column = 'purchasing_tracking'){     
                $guzzle = new Guzzle\Client([
                    'base_uri' => 'https://api.aftership.com/v4/',
                    'headers' => [ 
                        'as-api-key' => env('AFTERSHIP_DEFAULT'),
                        'Content-Type' => 'application/json'
                    ]
                ]);
		
                $request->tracking = $request->get('value');
                $tracking = $guzzle->get('trackings?keyword='.$request->tracking); 
                 
                $trackingDetailsResults = json_decode($tracking->getBody()->getContents());   

                
                if(!$trackingDetailsResults->data->trackings) {
                        
                    $addTracking = $guzzle->post('trackings', [
                        'body' => json_encode(['tracking' => [
                            'tracking_number' => $request->tracking
                        ]])
                    ]);  
        
                } 
 
            }
        }catch(\Exception $e){
            $error = $e->getMessage();
        }

        return compact('status','data','error');

    }

    public function postSSActiveWearOrder(Request $request){

        $status = false;
        $data = [];
        $error = '';
        $dataPosted = [];
        $newOrders = [];


        //get the total for each order

        //do the API

        $guzzle = new Guzzle\Client([
            'base_uri' => 'https://api.ssactivewear.com/v2/',
            'headers' => [ 
                'Authorization' => "Basic ". base64_encode(env('SS_USERNAME').':'.env('SS_PASSWORD')),
                'Content-Type' => 'application/json'
            ],
            'http_errors' => false
        ]);

        try {

            $orderData = Order::select(DB::Raw('*'),DB::Raw('orders.id AS id'))
            ->leftJoin('orders_meta','orders.id','=','orders_meta.order_id')
            ->whereIn('orders.id',explode(',',$request->ids))->get();

            $lines = [];

            $orderPo = "";

            foreach($orderData as $order){

                //first, check to see if there's even an existing S&S

                //get all SKU id's
                //loop through products

                

                $orderPo .= $order->id . " ";

                //first, check to see if there's even an existing S&S

                //get all SKU id's
                //loop through products

                $dt = $order->toArray();    

                foreach([1,2,3,4,5] as $num){

                    $sizes = ['xs','s','m','l','xl','xxl','xxxl', 'other_size_1', 'other_size_2', 'other_size_3', 'other_size_4'];

                    //get all style color products associated with this

                    if(isset($dt['product_'.$num.'_json']) && count($dt['product_'.$num.'_json']) > 0){
                        $colorStyles = StyleColorProduct::searchSpecific($dt['product_'.$num.'_json']['brand_name'],$dt['product_'.$num.'_json']['style_name'],$dt['product_'.$num.'_json']['color_name'])->get();

                        //match to corresponding quantities on the references side

                        foreach($sizes as $size){
                            //check if size is highlighted
                            if(isset($dt['ss_references_'.$num][$size]['highlighted']) && $dt['ss_references_'.$num][$size]['highlighted']){
                                //if it's highlighted, get the quantity

                                $sizeSpec = $size;

                                switch($size){
                                    case 'other_size_1':
                                        $sizeSpec = 'other_size_text_1';
                                    break;
                                    case 'other_size_2':
                                        $sizeSpec = 'other_size_text_2';
                                    break;
                                    case 'other_size_3':
                                        $sizeSpec = 'other_size_text_3';
                                    break;
                                    case 'other_size_4':
                                        $sizeSpec = 'other_size_text_4';
                                    break;

                                }

                                $quantity = intval($dt[$sizeSpec.'_'.$num]);
                                $pricePerPiece = 0;
                                $sizeToMatchWith = $dt['ss_references_'.$num][$size]['raw'];
                                    
                                foreach($colorStyles as $product){
                                    if($product->json_data['sizeName'] === $sizeToMatchWith){
                                        
                                        $currentCount = count($lines);
                 
                                        $lines[$currentCount] = [];

                                        $lines[$currentCount]['identifier'] = $product->sku;

                                        $lines[$currentCount]['qty'] = $quantity;

                                    }
                                }

                            }
                            
                        }
                    }

                }

                
                foreach([1,2,3,4,5] as $productIndex){

                    $scpCheck = StyleColorProduct::where(['sku' => $order->{'item_number_'.$productIndex}, 'apparel_source' => 's_and_s'])->first();

                    if($scpCheck === null){
                        continue;
                    }

                    $currentCount = count($lines);

                    $lines[$currentCount] = [];

                    $lines[$currentCount]['identifier'] = $order->{'item_number_'.$productIndex};

                    $lines[$currentCount]['qty'] = intval($order->{'s_'.$productIndex});

            

                }

            }

            $invoiceNum = $orderPo;

            $dataPosted = [
               "shippingAddress" => [
                     "customer" => "District Printing", 
                     "attn" => "Andrew Schwartz", 
                     "address" => "4722 S Normandie Ave", 
                     "city" => "Los Angeles", 
                     "state" => "CA", 
                     "zip" => "90037", 
                     "residential" => true 
                  ], 
               "shippingMethod" => "1", 
               "shipBlind" => false, 
               "poNumber" => $orderPo, 
               "rejectLineErrors" => false,
               "emailConfirmation" => "", 
               "testOrder" => boolval(env('SS_TESTORDER', 'true')), 
               "autoselectWarehouse" => true, 
               "lines" => $lines
            ];

            $response = $guzzle->post('orders', [
                'body' => json_encode($dataPosted)
            ]);

            $newOrders = json_decode($response->getBody()->getContents());

            //if something errored out, it wont give an array like it should but rather a an object with orders then line orders. API design insanity

            //error handling to be done later

            if(isset($newOrders->orders)){
                $designatedAsOrders = $newOrders->orders;
                $ssMetadata = $newOrders;
            }else{
                $designatedAsOrders = $newOrders;
                $ssMetadata = ['orders' => $newOrders];
            }

            $orderIds = [];

            $total = 0;

            /* Log::emergency(json_encode($newOrder)); */
            \Log::emergency(json_encode($designatedAsOrders) . '\n\n\n\n\n\nPosted Data:\n\n\n\n' . json_encode($dataPosted) . '\n\n\n\n\n\nOrder Data:\n\n\n\n' . json_encode($dataPosted). '\n\n\n\nOrder ID\'s: '. $request->ids);
            foreach($designatedAsOrders as $newOrder){
                $total = $total + floatval($newOrder->total);
                $orderIds[count($orderIds)] = $newOrder->orderNumber;
            }

            //update orders with SS invoice data

            //create new orders meta if none exist



            foreach($orderData as $order){

                $json3 = [];
                
                if($order->purchasing_invoice !== null){
                    //check if invoice ID already exists

                    $json3 = $order->purchasing_invoice;

                    $invoiceAlreadyExists = false;

                    $vacantIndex = 0;

                    foreach($json3['data'] as $index => $invoiceID){
                        if(strlen(trim($invoiceID).'') === 0){
                            $vacantIndex = $index;
                        }
                        if($invoiceID.'' === $invoiceNum.''){
                            $invoiceAlreadyExists = true;
                        }
                    }

                    if(!$invoiceAlreadyExists){
                        $json3['data'][$vacantIndex] = $invoiceNum;
                    }
                }else{
                    $json3 = ['data' => [@$invoiceNum.'','','']];
                }
                

                OrderMeta::updateOrInsert(
                    ['order_id' => $order->id],
                    ['ss_invoice' => $invoiceNum, 'ss_date' => DB::Raw('NOW()'),'ss_metadata' => json_encode($ssMetadata),'ss_po_1' => @$orderIds[0],'ss_po_2' => @$orderIds[1],'ss_po_3' => @$orderIds[2], 'updated_at' => DB::Raw('NOW()')]
                );
            }

   
            $status = true;

        }catch(\Exception $e){
            $originalError = $e->getMessage();
            $error = $originalError;

            \Log::emergency($error);

            \Log::emergency(json_encode($e->getTrace()));

            if(preg_match("#https://api.ssactivewear.com/v2/orders` resulted in a `400 Bad Request`#",$originalError)){
                //$error = 'Error With API Request. Please Try Again Later.';
            }
            if(preg_match("#ShippingAddress-City#",$originalError)){
                $error .= " (Bad shipping address in Order #". $orderDataToUse->id ." [". $orderDataToUse->name ."])";
            }

            if(strlen($error) > 140){
                //$error = substr($error,0,140).'...';
            }

            

        }

        $header = base64_encode(env('SS_USERNAME').':'.env('SS_PASSWORD'));

        return compact(['status','data','error', 'dataPosted']);
    }

    public function GetTrackingDetailsSS(Request $request){

        $error = null;
        $status = true;
        $data = [];

        try {
            $ssGuzzle = new Guzzle\Client([
                'base_uri' => 'https://api.ssactivewear.com/v2/',
                'headers' => [ 
                    'Authorization' => "Basic ". base64_encode(env('SS_USERNAME').':'.env('SS_PASSWORD')),
                    'Content-Type' => 'application/json'
                ]
            ]);

            //get order detail

            $response = $ssGuzzle->get('orders/'.$request->get('value'), [
                'body' => json_encode([])
            ]); 

            $data =  json_decode($response->getBody()->getContents()); 

            //only relevant part is the first order

            $data = $data[0];

            $orderIdReference = $request->get('id');

            if(!isset($data->trackingNumber) || (isset($data->trackingNumber) && strlen($data->trackingNumber) === 0)){
                $status = false;
                $error = 'No tracking number exists for this order yet. Please try again later.';
            }else{
                $asGuzzle = new Guzzle\Client([
                    'base_uri' => 'https://api.aftership.com/v4/',
                    'headers' => [ 
                        'as-api-key' => env('AFTERSHIP_DEFAULT'),
                        'Content-Type' => 'application/json'
                    ]
                ]);

                //check if tracking exists

                $tracking = $asGuzzle->get('trackings?keyword='.$data->trackingNumber);

                $trackingCreation = json_decode($tracking->getBody()->getContents());

                $data2 = $trackingCreation;

                $hasTrackingDataAlready = false;

                $trackingData = [];

                foreach($data2->data->trackings as $track){
                    if(strtoupper($track->tracking_number) === strtoupper($data->trackingNumber)){
                        $hasTrackingDataAlready = true;
                        $trackingData = $track;

                        if(count($track->checkpoints) > 0){
                            $shippingStatus = $track->checkpoints[count($track->checkpoints)-1]->subtag_message;
                        }

                        OrderMeta::updateOrInsert(['order_id' => $orderIdReference],['aftership_data' => json_encode($trackingCreation)]);

                        $data = $data2;
                    }
                }

                if(!$hasTrackingDataAlready){

                    //if not, create a new one with the tracking number

                    $trackingCreation = $asGuzzle->post('trackings', [
                        'body' => json_encode(['tracking' => [
                            'tracking_number' => $data->trackingNumber
                        ]])
                    ]);

                    $trackingDetailsResults = json_decode($trackingCreation->getBody()->getContents());

                    OrderMeta::updateOrInsert(['order_id' => $orderIdReference],['aftership_data' => json_encode($trackingDetailsResults)]);

                    $shippingId = $trackingDetailsResults->data->tracking->tracking_number;
                    $afterShipId = $trackingDetailsResults->data->tracking->id;

                    $trackingDetails = $asGuzzle->get('trackings/'.$afterShipId, [
                        'body' => ''
                    ]);

                    $data = $trackingDetailsResults;

                    $trackingDetailsResults = json_decode($trackingDetails->getBody()->getContents());

                    if(count($trackingDetailsResults->data->tracking->checkpoints) > 0){
                        $shippingStatus = $trackingDetailsResults->data->tracking->checkpoints[count($trackingDetailsResults->data->tracking->checkpoints)-1]->subtag_message;
                    }

                    $shippedDate = $trackingDetailsResults->data->tracking->shipment_delivery_date;

                    Order::find($orderIdReference)->update([
                        'tracking_number' => $shippingId
                    ]);

                }

                Order::find($orderIdReference)->update([
                    'shipping_des' => @$shippingStatus
                ]); 

            }

        }catch(\Exception $e){
            $error = $e->getMessage();
            $status = false;
        }

        

        return compact('error','status', 'data');
    }

    public function GroupSearcher(Request $request){

        $status = false;
        $data = false;

        //get SCP group by query      

        $data = ScpGroup::searchGroup($request->get('query'))->get();

        return compact('status','data');

    }
    
    /* code End */

    public function fulfillOrder($orderID){
        $order = Order::where(['id' => $orderID])->first();
        $orderMeta = OrderMeta::where(['order_id' => $orderID])->first();
        $orderShopifyMeta = json_decode($orderMeta->shopify_metadata);
        $lineItemId = $orderShopifyMeta->line_item_id;
        $hasLineItem = false;
        $lastLabel = PastLabels::where(['order_id' => $orderID])->orderBy('id','DESC')->first();
        if($lastLabel !== null){
            $lastLabel->metadata = json_decode($lastLabel->metadata);
        }
        foreach($orderShopifyMeta->line_items as $lineItem){
            if($lineItem->id.'' === $lineItemId.''){
                $lineItemData = $lineItem;
                $hasLineItem = true;
            }
        }
        //return compact('order','orderMeta','orderShopifyMeta', 'lineItemData');
        if(!$hasLineItem){
            throw new \Exception("No line item data found.");
        }
        $shopData = ShopifyIntegration::where(['id' => $orderShopifyMeta->shop_id])->first();
        // try {
        if($lastLabel !== null){
            $trackingData = json_decode($orderMeta->aftership_data)->data->tracking;
        }
        
        $client = new Guzzle\Client([
            'base_uri' =>  "https://".$shopData->shop_url."/admin/api/2023-01/",
            'headers' => [ 
                'X-Shopify-Access-Token' => $shopData->admin_access_api_key,
                'Content-Type' => 'application/json'
            ],
            'verify' => false
        ]);
        $orderFulfillment = $client->get('orders/'. $order->shopify_id .'/fulfillment_orders.json',[
            'body' => ''
        ]);
        $fulfillmentOrderData = json_decode($orderFulfillment->getBody()->getContents());
        if($fulfillmentOrderData !== null && count($fulfillmentOrderData->fulfillment_orders) > 0){
            $fulfillmentOrder = $fulfillmentOrderData->fulfillment_orders[count($fulfillmentOrderData->fulfillment_orders)-1]; //the last fulfillment order is the open one
            $lineItemExistsInFulfillmentOrder = false;
            foreach($fulfillmentOrder->line_items as $fli){
                if($fli->line_item_id.'' === $lineItemId.''){
                    $lineItemExistsInFulfillmentOrder = true;
                    $lineItemDataInFulfillment = $fli;
                }
            }
            $fulfillmentInput = [
                'line_items_by_fulfillment_order' => [
                    [
                        'fulfillment_order_id' => $fulfillmentOrder->id,
                        'fulfillment_order_line_items' => [
                            ['id' => $fli->id, 'quantity' => $fli->quantity]
                        ]
                    ]
                ]
            ];
            if($lastLabel !== null){
                $fulfillmentInput['tracking_info'] = [
                    'company' => $trackingData->slug,
                    'number' => $trackingData->tracking_number,
                    'url' => $trackingData->courier_tracking_link
                ];
            }
            $newFulfillment = $client->post('fulfillments.json',[
                'body' => json_encode(['fulfillment' => $fulfillmentInput])
            ]);
            $newFulfillmentData = json_decode($newFulfillment->getBody()->getContents());
            $orderShopifyMeta->fulfillment = $newFulfillmentData->fulfillment;
            OrderMeta::where(['order_id' => $orderID])->update(['shopify_metadata' => json_encode($orderShopifyMeta)]);
            return $newFulfillmentData;
        }else{
            throw new \Exception("No fulfillment order exists for this order.");
        }    
    }

    // Get Users List
    public function GetUsersList(Request $request) {
        if($request->isDeleted == 'true'){
            $users = User::select(DB::Raw('*'))->onlyTrashed();
        }else{
            $users = User::select(DB::Raw('*'));
        }
        
        if(auth()->user()->role == 'Sales' || auth()->user()->role == 'Trader') {
            $users = User::where('created_by', auth()->user()->id);
        }

        if($request->query !== null){
            $users = $users->where(function($query) use($request){
                $query->orWhere('first_name','like','%'.$request->get('query').'%')
                ->orWhere('last_name','like','%'.$request->get('query').'%')
                ->orWhere('email','like','%'.$request->get('query').'%');
            });
        }
   

        if($request->newui){
            $dataToReturn['data'] = $users->orderBy('first_name', 'ASC')->get();
        }else{
            $users = $users->paginate(6)->toArray();
        } 
        $dataToReturn['code'] = 200;
        $dataToReturn['success'] = true;
        $dataToReturn['message'] = 'Customer List.';

        return response()->json($dataToReturn);
    }
    
    // Get Vendors List
    public function GetVendorsList(Request $request) {
      /*   if($request->isDeleted == 'true'){
            $vendors = Vendor::select(DB::Raw('*'))->onlyTrashed();
        }else{
            $vendors = Vendor::select(DB::Raw('*'));
        }
         */
        $vendors = Vendor::whereIsDeleted(0);

        if($request->query !== null){
            $vendors = $vendors->where(function($query) use($request){
                $query->orWhere('first_name','like','%'.$request->get('query').'%')
                ->orWhere('last_name','like','%'.$request->get('query').'%')
                ->orWhere('email','like','%'.$request->get('query').'%');
            });
        }

        $dataToReturn = $vendors->paginate(6)->toArray();
        $dataToReturn['code'] = 200;
        $dataToReturn['success'] = true;
        $dataToReturn['message'] = 'Customer List.';

        return response()->json($dataToReturn);
    }

        // Get Vendors List Name
        public function GetVendorsListName(Request $request) {          
              $vendors = Vendor::whereIsDeleted(0)->get(['vendor_name']);  
              return $vendors;
        }
        
    // Get All Active Users List
    public function GetAllActiveUsersList(Request $request) {
        if($request->isDeleted == 'true'){
            $users = User::select(DB::Raw('*'))->onlyTrashed();
        }else{
            $users = User::select(DB::Raw('id,   CONCAT(first_name," ", last_name) as fullname,   role'));
        }
    
        
        $dataToReturn = $users->paginate(2000)->toArray();
        $dataToReturn['code'] = 200;
        $dataToReturn['success'] = true;
        $dataToReturn['message'] = 'Customer List.';

        return response()->json($dataToReturn);
    }

    // Create User
    public function CreateUser(Request $request) {
        $validator = Validator::make($request->all(), [
            'name' => 'required|max:100',
            'emails' => 'required|array|min:1',
            'emails.0.email' => 'required|email|max:150|unique:users,email', // Unique for the first email
            'emails.*.email' => 'required|email|max:150', // Validate format for all emails
            'role' => 'required|in:Admin,Etsy_Admin,Etsy_Customer,Production,Sales,Customer,Printer,Trader',
            'password' => 'nullable|min:6', // Password is now optional for update
            'phoneNumbers' => 'nullable|array',
            'phoneNumbers.*.phoneNumber' => 'nullable|max:100',
            'address' => 'nullable|max:1000',
            'street_appartment' => 'nullable|max:50',
            'city' => 'nullable|max:50',
            'state' => 'nullable|max:50',
            'zipcode' => 'nullable|max:50',
            'company' => 'nullable|max:50',

            'shipping_name' => 'nullable|max:100',
            'shipping_company' => 'nullable|max:50',
            'shipping_address' => 'nullable|max:1000',
            'shipping_street_appartment' => 'nullable|max:50',
            'shipping_phones' => 'nullable|array',
            'shipping_phones.*.phoneNumber' => 'nullable|max:100',
            'shipping_city' => 'nullable|max:50',
            'shipping_state' => 'nullable|max:50',
            'shipping_zipcode' => 'nullable|max:50',
            'shipping_emails' => 'nullable|array',
            'shipping_emails.*.email' => 'nullable|email|max:100',
            'production_manager' => 'nullable|boolean',
            'sales_tax_enabled' => 'nullable|boolean',
            'sales_tax' => 'nullable|numeric',
            'sms_required' => 'nullable|boolean',
            'email_token' => 'nullable|max:255',
            'isGmailService' => 'nullable|boolean',
            'terms' => 'nullable|boolean',
            'title' => 'nullable|max:100',
            /* 'avatar' => 'nullable|max:255', // Assuming avatar is a file path or URL
            'birthday' => 'nullable|date',
            'notes' => 'nullable|max:1000', */
            'tags' => 'nullable|array',
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        if (auth()->user()->role == 'Sales' && $request->role != 'Customer') {
            return response([
                'code' => 400,
                'success' => false,
                'message' => 'Only add customer type account'
            ]);
        }

        $user = new User;

        // Split the name into first and last name
        $nameParts = explode(' ', $request->name, 2);
        $user->first_name = $nameParts[0] ?? $user->first_name;
        $user->last_name = $nameParts[1] ?? $user->last_name;

 
        // Handle emails
        $emails = $request->emails;
        if (!empty($emails)) {
            $user->email = $emails[0]['email'] ?? $user->email; // Store first email address
            $user->email_label = $emails[0]['label'] ?? null; // Store first email label
            $additionalEmails = null;
            for ($i = 1; $i < count($emails); $i++) {
                $additionalEmails[]= $emails[$i];
            }
            $user->additional_emails = json_encode($additionalEmails);
        } else {
            $user->email = null;
            $user->email_label = null;
            $user->additional_emails = null;
        }

        // Handle phone numbers
        $phoneNumbers = $request->phoneNumbers;
        if (!empty($phoneNumbers)) {
            $user->contact_number = $phoneNumbers[0]['phoneNumber'] ?? $user->contact_number; // Store first phone number
            $user->contact_number_label = $phoneNumbers[0]['label'] ?? null; // Store first phone label
            $additionalPhoneNumbers = null;
            for ($i = 1; $i < count($phoneNumbers); $i++) {
                $additionalPhoneNumbers[]= $phoneNumbers[$i];
            }
            $user->additional_phone_numbers = json_encode($additionalPhoneNumbers);
        } else {
            $user->contact_number = null;
            $user->contact_number_label = null;
            $user->additional_phone_numbers = null;
        }


        $user->role = $request->role;
        $user->company = $request->company ?? $user->company;
        $user->address = $request->address ?? $user->address;
        $user->street_appartment = $request->street_appartment ?? $user->street_appartment;
        $user->state = $request->state ?? $user->state;
        $user->city = $request->city ?? $user->city;
        $user->zipcode = $request->zipcode ?? $user->zipcode;
        $user->terms = $request->terms ?? $user->terms;
        $user->sales_tax_enabled = $request->sales_tax_enabled ?? $user->sales_tax_enabled;
        $user->sales_tax = $request->sales_tax ?? $user->sales_tax;
        $user->sms_required = $request->sms_required ?? $user->sms_required;
        $user->email_token = $request->email_token ?? $user->email_token;
        $user->isGmailService = $request->isGmailService ?? $user->isGmailService;
        $user->title = $request->title ?? $user->title;
/*         $user->avatar = $request->avatar ?? $user->avatar;
        $user->birthday = $request->birthday ?? $user->birthday; 
        $user->notes = $request->notes ?? $user->notes;*/
        $user->tags = $request->tags ? json_encode($request->tags) : $user->tags;

        $user->status = 1;

        // Handle production manager logic more efficiently using Eloquent
        if ($request->production_manager === true) {
            User::query()->update(['production_manager' => false]);
        }
        $user->production_manager = $request->production_manager ?? false;

        // Shipping Information
        $shippingNameParts = explode(' ', $request->shipping_name, 2);
        $user->shipping_name = $shippingNameParts[0] ?? $user->shipping_name;
        $user->shipping_last_name = $shippingNameParts[1] ?? $user->shipping_last_name; 
 
        $user->shipping_company = $request->shipping_company ?? $user->shipping_company;
        $user->shipping_address = $request->shipping_address ?? $user->shipping_address;
        $user->shipping_street_appartment = $request->shipping_street_appartment ?? $user->shipping_street_appartment;
        $user->shipping_state = $request->shipping_state ?? $user->shipping_state;
        $user->shipping_city = $request->shipping_city ?? $user->shipping_city;
        $user->shipping_zipcode = $request->shipping_zipcode ?? $user->shipping_zipcode;
        // Handle shipping emails
        $shippingEmails = $request->shipping_emails;
        if (!empty($shippingEmails)) {
            $user->shipping_email = $shippingEmails[0]['email'] ?? $user->shipping_email; // Store first shipping email address
            $user->shipping_email_label = $shippingEmails[0]['label'] ?? null; // Store first shipping email label
            $additionalShippingEmails = null;
            for ($i = 1; $i < count($shippingEmails); $i++) {
                $additionalShippingEmails[]= $shippingEmails[$i];
            }
            $user->additional_shipping_emails = json_encode($additionalShippingEmails);
        } else {
            $user->shipping_email = null;
            $user->shipping_email_label = null;
            $user->additional_shipping_emails = null;
        }

        // Handle shipping phones
        $shippingPhones = $request->shipping_phones;
        if (!empty($shippingPhones)) {
            $user->shipping_phone = $shippingPhones[0]['phoneNumber'] ?? $user->shipping_phone; // Store first shipping phone number
            $user->shipping_phone_label = $shippingPhones[0]['label'] ?? null; // Store first shipping phone label
            $additionalShippingPhones = null;
            for ($i = 1; $i < count($shippingPhones); $i++) {
                $additionalShippingPhones[]= $shippingPhones[$i];
            }
            $user->additional_shipping_phones = json_encode($additionalShippingPhones);
        } else {
            $user->shipping_phone = null;
            $user->shipping_phone_label = null;
            $user->additional_shipping_phones = null;
        }

        // Password update is now conditional and validated
        if (isset($request->password) && $request->password !== 'undefined') {
            $user->password = bcrypt($request->password);
        }

        // Profile image update logic

        if($request->hasFile('profile_image')) {
            $folder = '/users/profile_image';
            $fileName = Misc::GenerateToken(10).'.'.$request->profile_image->getClientOriginalExtension();            
            $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->profile_image, $fileName, 'public'); 
            $user->profile_image = env('AWS_URL').$uploadPath;
            $extension = $request->profile_image->getClientOriginalExtension();
            if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                $thumb_tmp_path="../storage/tmp/". $fileName;
                $this->resize_crop_image(150,   $request->profile_image, $thumb_tmp_path);
                $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                $user->profile_image = env('AWS_URL') . $uploadThumbnailPath; 
                unlink($thumb_tmp_path);
            }
        } 

    
 
        if($user->save()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'User successfully created.',
                'data' => $user
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }

    //update user profile picture
    public function updateProfilePhoto(Request $request, $userId) {
         
 
        $user = User::find($userId);
        if(auth()->user()->role == 'Sales') {
            $user = User::where('created_by', auth()->user()->id)->where('id',$userId)->first();
        }
        if(!$user) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => 'User not found.'
            ]);
        }
 

  
    
        if($request->profile_image != 'undefined') {
            $folder = '/users/profile_image';
            $fileName = Misc::GenerateToken(10).'.'.$request->profile_image->getClientOriginalExtension();            
            $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->profile_image, $fileName, 'public'); 
            $user->profile_image = env('AWS_URL').$uploadPath;
            $extension = $request->profile_image->getClientOriginalExtension();
            if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                $thumb_tmp_path="../storage/tmp/". $fileName;
                $this->resize_crop_image(150,   $request->profile_image, $thumb_tmp_path);
                $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                $user->profile_image = env('AWS_URL') . $uploadThumbnailPath; 
                unlink($thumb_tmp_path);
            }
        }  
        
        if($user->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'User successfully updated.',
                'status' => 'success',
                'data' => $user
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }

    // Update User
    public function UserUpdate(Request $request, $userId)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|max:100',
            'emails' => 'required|array|min:1',
            'emails.0.email' => 'required|email|max:150|unique:users,email,' . $userId, // Unique for the first email
            'emails.*.email' => 'required|email|max:150', // Validate format for all emails
            'role' => 'required|in:Admin,Etsy_Admin,Etsy_Customer,Production,Sales,Customer,Printer,Trader',
            'password' => 'nullable|min:6', // Password is now optional for update
            'phoneNumbers' => 'nullable|array',
            'phoneNumbers.*.phoneNumber' => 'nullable|max:100',
            'address' => 'nullable|max:1000',
            'street_appartment' => 'nullable|max:50',
            'city' => 'nullable|max:50',
            'state' => 'nullable|max:50',
            'zipcode' => 'nullable|max:50',
            'company' => 'nullable|max:50',

            'shipping_name' => 'nullable|max:100',
            'shipping_company' => 'nullable|max:50',
            'shipping_address' => 'nullable|max:1000',
            'shipping_street_appartment' => 'nullable|max:50',
            'shipping_phones' => 'nullable|array',
            'shipping_phones.*.phoneNumber' => 'nullable|max:100',
            'shipping_city' => 'nullable|max:50',
            'shipping_state' => 'nullable|max:50',
            'shipping_zipcode' => 'nullable|max:50',
            'shipping_emails' => 'nullable|array',
            'shipping_emails.*.email' => 'nullable|email|max:100',
            'production_manager' => 'nullable|boolean',
            'sales_tax_enabled' => 'nullable|boolean',
            'sales_tax' => 'nullable|numeric',
            'sms_required' => 'nullable|boolean',
            'email_token' => 'nullable|max:255',
            'isGmailService' => 'nullable|boolean',
            'terms' => 'nullable|boolean',
            'title' => 'nullable|max:100',
            /* 'avatar' => 'nullable|max:255', // Assuming avatar is a file path or URL
            'birthday' => 'nullable|date',
            'notes' => 'nullable|max:1000', */
            'tags' => 'nullable|array',
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $user = User::find($userId);
        if (auth()->user()->role == 'Sales') {
            $user = User::where('created_by', auth()->user()->id)->where('id', $userId)->first();
        }
        if (!$user) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => 'User not found.'
            ]);
        }

        // Split the name into first and last name
        $nameParts = explode(' ', $request->name, 2);
        $user->first_name = $nameParts[0] ?? $user->first_name;
        $user->last_name = $nameParts[1] ?? $user->last_name;

 
        // Handle emails
        $emails = $request->emails;
        if (!empty($emails)) {
            $user->email = $emails[0]['email'] ?? $user->email; // Store first email address
            $user->email_label = $emails[0]['label'] ?? null; // Store first email label
            $additionalEmails = null;
            for ($i = 1; $i < count($emails); $i++) {
                $additionalEmails[] = $emails[$i];
            }
            $user->additional_emails = json_encode($additionalEmails);
        } else {
            $user->email = null;
            $user->email_label = null;
            $user->additional_emails = null;
        }

        // Handle phone numbers
        $phoneNumbers = $request->phoneNumbers;
        if (!empty($phoneNumbers)) {
            $user->contact_number = $phoneNumbers[0]['phoneNumber'] ?? $user->contact_number; // Store first phone number
            $user->contact_number_label = $phoneNumbers[0]['label'] ?? null; // Store first phone label
            $additionalPhoneNumbers = null;
            for ($i = 1; $i < count($phoneNumbers); $i++) {
                $additionalPhoneNumbers[]= $phoneNumbers[$i];
            }
            $user->additional_phone_numbers = json_encode($additionalPhoneNumbers);
        } else {
            $user->contact_number = null;
            $user->contact_number_label = null;
            $user->additional_phone_numbers = null;
        }


        $user->role = $request->role;
        $user->company = $request->company ?? $user->company;
        $user->address = $request->address ?? $user->address;
        $user->street_appartment = $request->street_appartment ?? $user->street_appartment;
        $user->state = $request->state ?? $user->state;
        $user->city = $request->city ?? $user->city;
        $user->zipcode = $request->zipcode ?? $user->zipcode;
        $user->terms = $request->terms ?? $user->terms;
        $user->sales_tax_enabled = $request->sales_tax_enabled ?? $user->sales_tax_enabled;
        $user->sales_tax = $request->sales_tax ?? $user->sales_tax;
        $user->sms_required = $request->sms_required ?? $user->sms_required;
        $user->email_token = $request->email_token ?? $user->email_token;
        $user->isGmailService = $request->isGmailService ?? $user->isGmailService;
        $user->title = $request->title ?? $user->title;
/*         $user->avatar = $request->avatar ?? $user->avatar;
        $user->birthday = $request->birthday ?? $user->birthday; 
        $user->notes = $request->notes ?? $user->notes;*/
        $user->tags = $request->tags ? json_encode($request->tags) : $user->tags;

        $user->status = 1;

        if ($request->production_manager === true) {
            User::query()->where('id', '!=', $userId)->update(['production_manager' => false]);
        }
        $user->production_manager = $request->production_manager ?? $user->production_manager;

        // Shipping Information
        $shippingNameParts = explode(' ', $request->shipping_name, 2);
        $user->shipping_name = $shippingNameParts[0] ?? $user->shipping_name;
        $user->shipping_last_name = $shippingNameParts[1] ?? $user->shipping_last_name; 
 
        $user->shipping_company = $request->shipping_company ?? $user->shipping_company;
        $user->shipping_address = $request->shipping_address ?? $user->shipping_address;
        $user->shipping_street_appartment = $request->shipping_street_appartment ?? $user->shipping_street_appartment;
        $user->shipping_state = $request->shipping_state ?? $user->shipping_state;
        $user->shipping_city = $request->shipping_city ?? $user->shipping_city;
        $user->shipping_zipcode = $request->shipping_zipcode ?? $user->shipping_zipcode;
        // Handle shipping emails
        $shippingEmails = $request->shipping_emails;
        if (!empty($shippingEmails)) {
            $user->shipping_email = $shippingEmails[0]['email'] ?? $user->shipping_email; // Store first shipping email address
            $user->shipping_email_label = $shippingEmails[0]['label'] ?? null; // Store first shipping email label
            $additionalShippingEmails = null;
            for ($i = 1; $i < count($shippingEmails); $i++) {
                $additionalShippingEmails[]= $shippingEmails[$i];
            }
            $user->additional_shipping_emails = json_encode($additionalShippingEmails);
        } else {
            $user->shipping_email = null;
            $user->shipping_email_label = null;
            $user->additional_shipping_emails = null;
        }

        // Handle shipping phones
        $shippingPhones = $request->shipping_phones;
        if (!empty($shippingPhones)) {
            $user->shipping_phone = $shippingPhones[0]['phoneNumber'] ?? $user->shipping_phone; // Store first shipping phone number
            $user->shipping_phone_label = $shippingPhones[0]['label'] ?? null; // Store first shipping phone label
            $additionalShippingPhones = null;
            for ($i = 1; $i < count($shippingPhones); $i++) {
                $additionalShippingPhones[]= $shippingPhones[$i];
            }
            $user->additional_shipping_phones = json_encode($additionalShippingPhones);
        } else {
            $user->shipping_phone = null;
            $user->shipping_phone_label = null;
            $user->additional_shipping_phones = null;
        }

        // Password update is now conditional and validated
        if (isset($request->password) && $request->password !== 'undefined') {
            $user->password = bcrypt($request->password);
        }

        // Profile image update logic

        if($request->hasFile('profile_image')) {
            $folder = '/users/profile_image';
            $fileName = Misc::GenerateToken(10).'.'.$request->profile_image->getClientOriginalExtension();            
            $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->profile_image, $fileName, 'public'); 
            $user->profile_image = env('AWS_URL').$uploadPath;
            $extension = $request->profile_image->getClientOriginalExtension();
            if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                $thumb_tmp_path="../storage/tmp/". $fileName;
                $this->resize_crop_image(150,   $request->profile_image, $thumb_tmp_path);
                $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                $user->profile_image = env('AWS_URL') . $uploadThumbnailPath; 
                unlink($thumb_tmp_path);
            }
        } 

        if ($user->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'User successfully updated.',
                'data' => $user
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }



    public function OrderTypeUpdate(Request $request, $userId){
        if($request->delete) {  
            $order_type = UserOrderType::where('name', $request->name)->first(); 
            if($order_type){
                $order_type->deleted_at = \Carbon\Carbon::now();
                $order_type->update();
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Successfully updated.', 
                    'data' => UserOrderType::all()
                ]);
            }else{
                $order_type = UserOrderType::create([ 
                    'name' => $request->name 
                ]);
                $order_type->deleted_at = \Carbon\Carbon::now();
                $order_type->update();
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Successfully updated.', 
                    'data' => UserOrderType::all()
                ]);
            }
            
        }else{
            $order_type = UserOrderType::where('name', $request->name)->first();
            if($order_type){
                if($request->payment){
                    $order_type->payment = $this->isNull($request->payment);
                }
                if($request->art){
                    $order_type->art = $this->isNull($request->art);
                }
                if($request->film){                
                    $order_type->film = $this->isNull($request->film);
                }
                if($request->apparel){
                    $order_type->apparel = $this->isNull($request->apparel);
                }
                if($order_type->update()) {
                    $getList =  UserOrderType::where('deleted_at', null)->get();
                    return response([
                        'code' => 200,
                        'success' => true,
                        'message' => 'Successfully updated.',
                        'data' => $getList
                    ]);
                } else {
                    return response([
                        'code' => 401,
                        'success' => false,
                        'message' => 'Not updated.' 
                    ]);
                }
    
            }else{
                $order_type = UserOrderType::create([ 
                    'name' => $request->name,
                    'payment' => $this->isNull($request->payment),
                    'art' => $this->isNull($request->art),
                    'film' => $this->isNull($request->film),
                    'apparel' => $this->isNull($request->apparel) 
                ]);
                
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Successfully updated.',
                    'isNewRow' => true,
                    'data' => $order_type
                ]);
            }
        }
      
    }


    public function orderTypeCreate(Request $request){

        if($request->orderType !=''){
            $order_type = UserOrderType::create([ 
                'name' => $request->orderType,   
                'category_id' => $request->categoryId  
            ]);
            
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Successfully updated.',
                'isNewRow' => true,
                'data' => UserOrderType::all()
            ]);
        }
        
      
    }
    public function isEmpty($value) {
        $result = "";
        if(isset($value) && !empty($value)){
            $result = $value;
        }            
        return $result; 
    }
 
    public function isNull($value) {
        $result = null;
        if(isset($value) && !empty($value)){
            $result = $value;
        } 
        
        if($value == 'false' || $value == false){
            $result = null;
        }
        return $result; 
    }

    public function isEmptyValue($value) {
        $result = false;
        if(isset($value) && !empty($value)){
            $result = true;
        }            
        return $result; 
    }

    public function getTraderJson($companyName) {

        $store = Storage::get('/public/assets/users/company_logo/'. $companyName . '.json');
        return $store; 

    /*     $jsonFolder = './public/assets/users/company_logo/'. $companyName . '.json'; 
        $store = \Storage::disk('s3')->get(json_encode($jsonFolder));
        return $store; */
 
   /*      $user = User::where('company_url',$companyName)->first();

        $data = [
            "company_name" =>  $user->company_name, 
            "company_url" =>  $user->company_url, 
            "company_logo" =>  $user->company_logo, 
            "trader_email" =>  $user->trader_email, 
            "phone" =>  $user->contact_number, 
            "address" =>  $user->address . ' ' . $user->city . ' ' . $user->state . ' ' . $user->zipcode       
        ];

        return json_encode($data); */
    }

    public function TraderUpdate(Request $request, $userId) {

        $validator = Validator::make($request->all(), [          
            'company_name' => 'required',
            'company_url' => 'required',
            'company_logo' => 'required',
          /*   'trader_email' => 'required', 
            'trader_username' => 'required',
            'trader_password' => 'required',
            'trader_transport' => 'required',
            'trader_host' => 'required',
            'trader_port' => 'required',
            'trader_encryp' => 'required',     */    
        ]);


        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $user = User::find($userId);
        if(auth()->user()->role == 'Sales') {
            $user = User::where('created_by', auth()->user()->id)->where('id',$userId)->first();
        }
        if(!$user) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => 'User not found.'
            ]);
        }

   

        $user->company_name = $this->isEmpty($request->company_name);
        $user->company_url = $this->isEmpty($request->company_url);
        $user->trader_email = $this->isEmpty($request->trader_email);
        $user->trader_username = $this->isEmpty($request->trader_username);
        $user->trader_password = $this->isEmpty($request->trader_password);
        $user->trader_transport = $this->isEmpty($request->trader_transport);
        $user->trader_host = $this->isEmpty($request->trader_host);
        $user->trader_port = $this->isEmpty($request->trader_port);
        $user->trader_encryp = $this->isEmpty($request->trader_encryp);  
        $user->trader_order_type = $this->isEmpty($request->trader_order_type);  
        $user->trader_order_type_primary = $this->isEmpty($request->trader_order_type_primary);  
        $user->role = "Trader"; 
 
        if($request->company_logo != 'undefined') {
            if (filter_var($request->company_logo, FILTER_VALIDATE_URL)) {
                $user->company_logo = $request->company_logo;
            }else{
                $folder = '/users/company_logo';
                $extension = $request->company_logo->getClientOriginalExtension();
                if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                    $fileName = $user->company_url .'.png';            
                    $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->company_logo, $fileName, 'public'); 
                    $user->company_logo = env('AWS_URL').$uploadPath;
                    $thumb_tmp_path="../storage/tmp/". $fileName;
                    $this->resize_crop_image_png(240,   $request->company_logo, $thumb_tmp_path);
                    $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                    $user->company_logo = env('AWS_URL') . $uploadThumbnailPath; 
                    unlink($thumb_tmp_path);
                }
            }
        }  

        $data = [
            "company_name" =>  $user->company_name, 
            "company_url" =>  $user->company_url, 
            "company_logo" =>  $user->company_logo, 
            "trader_email" =>  $user->trader_email, 
            "phone" =>  $user->contact_number, 
            "address" =>  $user->address . ' ' . $user->city . ' ' . $user->state . ' ' . $user->zipcode       
        ];
        
        $jsonFolder = '/users/company_logo/'. $user->company_url . '.json'; ;
        $store = \Storage::disk('s3')->put($jsonFolder, json_encode($data));

        if($user->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Trader successfully updated.',
                'data' => $user
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }

    public function OrderTypeList() {
        $orderType = UserOrderType::all();

        return response([
            'code' => 200,
            'success' => true,
            'message' => 'Order Type List.',
            'data' => $orderType
        ]);
    }

    public function UpdateTrackingStatus(){

        DB::enableQueryLog();

        $ordersToUpdate = Order::where([
           ['status' , '!=', 'Completed']
        ])->whereNotNull(['tracking_number'])->get();

        $guzzle = new Guzzle\Client([
            'base_uri' => 'https://api.aftership.com/v4/',
            'headers' => [ 
                'as-api-key' => env('AFTERSHIP_DEFAULT'),
                'Content-Type' => 'application/json'
            ]
        ]);



        $error = null;
        $status = true;

        foreach($ordersToUpdate as $order):

            $orderID = $order->id;

            //check to see if the order has an aftership data

            $orderMeta = OrderMeta::where(['order_id' => $orderID])->first();
            $order = Order::where(['id' => $orderID])->first();

            if($orderMeta === null){
                OrderMeta::upsert([ 
                    'order_id' => $orderID,
                    'aftership_data' => '{}'
                ], ['order_id'], ['aftership_data']);

                $orderMeta = OrderMeta::where(['order_id' => $orderID])->first();
            }

            try {

               


                if($orderMeta->aftership_data === null || count((array) json_decode($orderMeta->aftership_data) ) === 0){
                     $trackingCreation = $guzzle->post('trackings', [
                        'body' => json_encode(['tracking' => [
                            'tracking_number' => $order->tracking_number
                        ]])
                    ]);

                    $trackingDetailsResults = json_decode($trackingCreation->getBody()->getContents());
                    OrderMeta::where(['order_id' => $orderID])->update(['aftership_data' => json_encode($trackingDetailsResults)]);
                    $shippingId = $trackingDetailsResults->data->tracking->tracking_number;
                    $afterShipId = $trackingDetailsResults->data->tracking->id;
                }else{
                    $details = json_decode($orderMeta->aftership_data);
                    $shippingId = $details->data->tracking->tracking_number;
                    $afterShipId = $details->data->tracking->id;
                }

            }catch(\Exception $e){
                $trackingDetailsResults = null;
                $error = $e->getMessage();
                $status = false;
            }

            $shippingStatus = 'Pending';

            $trackingDetailsResults = [];

            //try {
                $trackingDetails = $guzzle->get('trackings/'.$afterShipId, [
                    'body' => ''
                ]);

                $trackingDetailsResults = json_decode($trackingDetails->getBody()->getContents());

                if(count($trackingDetailsResults->data->tracking->checkpoints) > 0){
                    $shippingStatus =  $trackingDetailsResults->data->tracking->checkpoints[count($trackingDetailsResults->data->tracking->checkpoints)-1]->subtag_message;
                }

                $shippedDate = $trackingDetailsResults->data->tracking->shipment_delivery_date;

                Order::find($orderID)->update([
                    'shipping_des' => $shippingStatus,
                    'ship_type' => $trackingDetailsResults->data->tracking->shipment_type
                ]);

            // }catch(\Exception $e){
            //     $error = $e->getMessage();
            //     $status = false;
            // }        

        endforeach;     

    }

 
    // Delete User
    public function DeleteUser(Request $request, $userId) {
       
       $userdel = DB::delete('DELETE FROM users WHERE id = ?', [$userId]);
        // if(auth()->user()->role == 'Sales') {
        //     $user = User::where('created_by', auth()->user()->id)->where('id',$userId)->first();
        // }
        if($userdel) {
            //based on Andrew discussion applied hard delete of user record
           // $user->deleted_at = date('Y-m-d H:i:s');
            if($userdel) {
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Account successfully deleted.'
                ]);
            } else {
                return response([
                    'code' => 500,
                    'success' => false,
                    'message' => 'Something went wrong, Try again later.'
                ]);
            }
        } else {
            return response([
                'code' => 400,
                'success' => false,
                'message' => 'User not found.'
            ]);
        }
    }

    // Update User Status
    public function UserStatus(Request $request, $userId) {
        $user = User::find($userId);
        if(auth()->user()->role == 'Sales') {
            $user = User::where('created_by', auth()->user()->id)->where('id',$userId)->first();
        }
        if($user) {
            $user->status = !$user->status;
            if($user->update()) {
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Account status updated.'
                ]);
            } else {
                return response([
                    'code' => 500,
                    'success' => false,
                    'message' => 'Something went wrong, Try again later.'
                ]);
            }
        } else {
            return response([
                'code' => 400,
                'success' => false,
                'message' => 'User not found.'
            ]);
        }
    }

        // Update Default User Id for Trader
        public function updateDefaultUserId(Request $request, $userId) {
             
            if(auth()->user()->role == 'Trader') {
                $user = User::where('id', auth()->user()->id)->first();
            }
            if($user) {
                if($userId){
                    $user->default_user_id = $userId;
                }else{
                    $user->default_user_id = null;
                }
                
                if($user->update()) {
                    return response([
                        'code' => 200,
                        'success' => true,
                        'message' => 'Default Id updated.',
                        'data' => $user
                    ]);
                } else {
                    return response([
                        'code' => 500,
                        'success' => false,
                        'message' => 'Something went wrong, Try again later.'
                    ]);
                }
            } else {
                return response([
                    'code' => 400,
                    'success' => false,
                    'message' => 'this is not Trade User.'
                ]);
            }
        }
    // Enable User
    public function EnableUser(Request $request, $userId) {
        $user = User::withTrashed()->find($userId)->restore();
         
         if($user) {
              
                 return response([
                     'code' => 200,
                     'success' => true,
                     'message' => 'Account successfully Enabled.'
                 ]);
             
         } else {
             return response([
                 'code' => 400,
                 'success' => false,
                 'message' => 'User not found.'
             ]);
         }
     }
    // Update order status
    public function UpdateOrderStatus(Request $request, $orderId) {
        $order = Order::with('orders_meta')->find($orderId);
        $orderDetails = OrderDetails::where('order_id', $orderId)->first();
        $user = User::where('id',$order->created_by)->first();
        $companyName = "District Printing";
        $emailToSendTo = @$user->email;
        $bcc=["notifications@districtprinting.tech"];  
        $customer = User::where('id',$order->customer_id)->first();
        if($user->role == 'Trader'){  
            Config::set('mail',$this->traderMailConfig($user));  
            $companyName = $user->company_name; 

        } 

        if(!auth('api')->check()){

            //check if validation code is there

            try {

                $accessCodeData = AccessCode::where(['order_id' => $orderId, 'code' => $request->get('code')])->first();



                if($request->code === null || $accessCodeData === null){
                    return response()->json([
                        'code' => 401,
                        'success' => false,
                        'message' => 'Unauthorized access.',
                    ]);
                }

            }catch(\Exception $e){

                return response()->json([

                    'code' => 401,
                    'success' => false,
                    'message' => $e->getMessage(),
                ]);
            }

        }else{


            if(auth('api')->user()->role !== 'Sales' && auth('api')->user()->role !== 'Trader' && auth('api')->user()->role !== 'Admin' && auth('api')->user()->role !== 'Etsy_Admin'){
                return response()->json([
                    'code' => 401,
                    'success' => false,
                    'message' => 'Unauthorized access.',
                ]);
            }   
        }


        
        if(!$order) {
            return  response([
                'code' => 404,
                'success' => false,
                'message' => 'No order found',
            ]);
        }

        if(isset($request->art_is_sized))
            $order->art_is_sized = $request->art_is_sized == 'true' ? true: false;

        if(isset($request->pay)){
            $order->pay = $request->pay == 'true' ? true: false;
            if($request->pay == 'true'){
                ActivityNotif::create([
                    'order_id' => $order->id,
                    'title' => 'Marked ' . $order->id,
                    'description' => $order->name,
                    'initiated_by' => $order->created_by,
                    'action' => 'marked_as_paid',
                    'type' => 'admin' 
                ]);
                $time = \Carbon\Carbon::now();
                /* $uniqueKey = $order->id .'-'.'VendorOrderPlacement';
                OrderEmailQueue::updateOrInsert(['order_id' => $uniqueKey],[
                    'order_id' => $order->id,
                    'email_type' => 'VendorOrderPlacement',
                    'created_at' => $time,
                    'updated_at' => $time
                ]); */ 
                $OrderEmailQueue = OrderEmailQueue::where('order_id',$order->id)->where('email_type','VendorOrderPlacement')->first();
                if($OrderEmailQueue){
                    $OrderEmailQueue->email_type = 'VendorOrderPlacement';
                    $OrderEmailQueue->updated_at = $time;
                    $OrderEmailQueue->update();
                }
            }
        }

        if(isset($request->apparel)){
            $order->apparel = $request->apparel  == 'true' ? true: false;

            if($order->apparel){
                $activeNotification = ActivityNotif::where([['order_id','=' ,$order->id],['action', '=' ,'apparel_received']])->count();
                if($activeNotification === 0){
                    ActivityNotif::create([
                        'order_id' => $order->id,
                        'title' => 'Apparel Ordered for ' . $order->id,
                        'description' => $order->name,
                        'initiated_by' => $order->created_by,
                        'action' => 'apparel_received',
                        'type' => 'admin' 
                    ]);
                } 
            }

        }    



        if(isset($request->film)){
            $order->film = $request->film  == 'true' ? true: false;
            if($order->film){
                ActivityNotif::create([
                    'order_id' => $order->id,
                    'title' => 'Film Uploaded for ' . $order->id,
                    'description' => $order->name,
                    'initiated_by' => $order->created_by,
                    'action' => 'film_uploaded',
                    'type' => 'admin' 
                ]);
            }

        }

        if(isset($request->invoice))
            $order->invoice = $request->invoice == 'true' ? 1: 0;

        if(isset($request->invoice_number))
            $order->invoice_number = $request->invoice_number;

        if(isset($request->type_notes))
            $order->type_notes = $request->type_notes;

        if(isset($request->po_number))
            $order->po_number = $request->po_number;

        if(isset($request->tracking_number))
            $order->tracking_number = $request->tracking_number;

        if(isset($request->printer_id))
            $order->printer_id = $request->printer_id;

        if(isset($request->s_intro_email))
            $order->s_intro_email = $request->s_intro_email;

        if(isset($request->s_send_proof))
            $order->s_send_proof = $request->s_send_proof;

        if(isset($request->s_proof_approved))
            $order->s_proof_approved = $request->s_proof_approved;

        if(isset($request->s_rush_shipping_paid))
            $order->s_rush_shipping_paid = $request->s_rush_shipping_paid;

        if(isset($request->s_follow_up))
            $order->s_follow_up = $request->s_follow_up;

        if(isset($request->film_notes))
            $order->film_notes = $request->film_notes;

        if(isset($request->isOrderedType)){

                if(isset($request->is_ordered_1))
                    $order->is_ordered_1 = $request->is_ordered_1 == 'true' ? 1: 0;
    
                if(isset($request->is_ordered_2))
                    $order->is_ordered_2 = $request->is_ordered_2 == 'true' ? 1: 0;
        
                if(isset($request->is_ordered_3))
                    $order->is_ordered_3 = $request->is_ordered_3 == 'true' ? 1: 0;
        
                if(isset($request->is_ordered_4))
                    $order->is_ordered_4 = $request->is_ordered_4 == 'true' ? 1: 0;
        
                if(isset($request->is_ordered_5))
                    $order->is_ordered_5 = $request->is_ordered_5 == 'true' ? 1: 0;
        

                $apparelCount = 0;
                $isPurchasedCount = 0; 
                for($i = 1; $i <= 5; $i++) {
                    if($order['product_apparel_source_'.$i] !== null
                    || $order['xs_'.$i] !== null
                    || $order['s_'.$i] !== null
                    || $order['m_'.$i] !== null
                    || $order['l_'.$i] !== null
                    || $order['xl_'.$i] !== null
                    || $order['xxl_'.$i] !== null
                    || $order['xxxl_'.$i] !== null
                    || $order['other_size_text_1_'.$i] !== null
                    || $order['other_size_text_2_'.$i] !== null
                    || $order['other_size_text_3_'.$i] !== null
                    || $order['other_size_text_4_'.$i] !== null)
                    { $apparelCount++; }

                    if($order['is_ordered_'.$i] === 1 || $order['product_apparel_source_'.$i] === 'provided')
                    { $isPurchasedCount++; }
                } 

                $order->apparel_row_count = $apparelCount;
                $order->is_purchased_row_count = $isPurchasedCount;

                if($apparelCount > 0 && $apparelCount  <= $isPurchasedCount){
                  
                     
                    $activeNotification1 = ActivityNotif::where([['order_id','=' ,$order->id],['action', '=' ,'apparel_purchased']])->count();
                    if($activeNotification1 === 0){
                        ActivityNotif::create([
                            'order_id' => $order->id,
                            'title' => 'Apparel Ordered for ' . $order->id,
                            'description' => $order->name,
                            'initiated_by' => $order->created_by,
                            'action' => 'apparel_purchased',
                            'type' => 'admin' 
                        ]);
                    } 
                     
                }  
        }
            
        

        if(isset($request->production) && $request->production == 'true') {

            $order->status = 'Production';
            /* if($order->customer_id.'' !== '-1'){
                try {
                    $user = User::findOrFail($order->created_by);
                }catch(\Exception $e){
                    return "findOrFail"  . $e->getMessage();
                }
                
                $emailToSendTo = $user->email;

                 
            } */
              
            /* $orderArt = OrderArt::whereOrderId($order->id)->get(); */
            if($order->resource_id !== null) {
                if(($this->isEmpty($order->shopify_id)  || $this->isEmpty($order->etsy_id)) == false ){
                    try {
                        $resource_user = Resource::find($order->resource_id);  
                        Mail::to($resource_user->email)->cc($emailToSendTo)->bcc($bcc)->send(new ResourceEmail($user,$order));    
                        

                        $accessCodeData = AccessCode::where(['order_id' => $order->id])->first();

                        Twilio::message($resource_user->sms, 
                            'Order #'. $order->id .''. "\n\n" .'Due '. date('n / j', strtotime($order->arrival_date) ) .'. Thank you.'. "\n" .'
                            '.env('FRONTEND_URL').'#/resource-view?order_id='.$order->id.'&page=resources&code='.$accessCodeData->code);


                        }catch(\Exception $e){
                            return ['error' => $e->getMessage(), 'status' => false];
                        }
                }
            }
            
 
            /* if($customer !== null && $customer->sms_required == 'true' && ($order->customer_phone !== null)) { */
            if($order->customer_phone !== null && $order->customer_phone !== '3109169514') {
                $arrivalDate = date('D, F jS', strtotime($order->arrival_date));
                try {
                    if($customer->role  == 'Customer' && $customer->sms_required == 'true' && $customer->contact_number !== '3109169514' ){
                         
                            Twilio::message($order->customer_phone, 'Your order, '.$order->name.'   is in production, with an estimated completion date of '.$arrivalDate.'. - '.$companyName);
                        
                    }/* else{
                        Twilio::message($order->customer_phone, 'Your order, '.$order->name.'   is in production, with an estimated completion date of '.$arrivalDate.'. - District Printing');

                    }  */
                }catch(\Exception $e){
                    
                }
            } 
           

                 
            try {   
                if($this->isEmptyValue($order->shopify_id) || $this->isEmptyValue($order->etsy_id)){
                    Mail::to($emailToSendTo)->bcc($bcc)->send(new OrderProduction($user, $order));  
                }else{
                    Mail::to($order->customer_email)->cc($emailToSendTo)->bcc($bcc)->send(new OrderProduction($user, $order)); 
                                       
                }
            }catch(\Exception $e){
                return $e->getMessage();
            }        


        }

                
            if(isset($request->production) && $request->production == 'false'){
                if($order->shopify_id !== null){
                    try {
                        $this->fulfillOrder($order->id);
                    }catch(\Exception $e){
                        // return ['trace' => $e->getTrace(), 'message' => $e->getMessage()];                    
                    }
                }
                ActivityNotif::create([
                    'order_id' => $order->id,
                    'title' => 'Order Completed  - ' . $order->id,
                    'description' => $order->name,
                    'initiated_by' => $order->created_by,
                    'action' => 'order_completed',
                    'type' => 'order_status' 
                ]);
                if($order->customer_phone !== null) {
                    $arrivalDate = date('D, F jS', strtotime($order->arrival_date));
                    try {               
                        if($customer->role  == 'Customer' && $customer->contact_number !== '3109169514' && $customer->sms_required == 'true'){
                             
                                Twilio::message($order->customer_phone, 'Your order  '.$order->name.' is complete and is preparing for shipping. - '. $companyName);   
                            
                        }/* else{
                                Twilio::message($order->customer_phone, 'Your order  '.$order->name.' is complete and is preparing for shipping. - District Printing');   
                        }  */
                    }catch(\Exception $e){
                        
                    }
                } 
            } 

            if(
                isset($request->apparel) ||
                isset($request->film) ||
                isset($request->art_is_sized) ||
                isset($request->pay) 
            ){
          
                $order = $this->updateStatusToProduction($order,$companyName);      

            }



            if((isset($request->completed) && $request->completed == 'true') || (isset($request->production) && $request->production == 'false')) {
                $order->status = 'Completed';
                $order->trader_printer_id = null;
                /* $user = User::find($order->created_by);
                $emailToSendTo = $user->email; */

                switch($order->ship_type){
                    default:
                        $type = 'shipping';
                    break;
                    case 'pickup':
                    case 'pickup-9am':
                    case 'pickup-5pm':
                    case 'uber':
                    case 'hand_deliver':
                    case null:
                    case '':
                        $type = 'pickup';
                    break;
                    case 'manually_shipped':
                        $type = 'manually_shipped';
                    break;
                    case 'Provided Label':
                        $type = 'provided_label';
                    break;

                }
     

                try {
                    $emailQueues = OrderEmailQueue::where('order_id', $order->id)->where('email_type', 'OrderCompleted')->where('is_mail_sent', 1)->count();  
                    if($emailQueues == 0){ 

                        //generate access code
                        $accessCode = md5(time());

                        //check to see if order already has an access code                         
                        if($orderDetails){ 
                            if($orderDetails->access_code === null){  
                                $orderDetails->update(['access_code' => $accessCode]);  
                            }
                        } 

                        if($this->isUber($order) == true){ 
                            if($order->customer_phone !== '3109169514'){   
                                Twilio::message($order->customer_phone, 
                                'Your order is ready! Want it delivered to '.$order->customer_address.'? Check your email or click the link below to instantly book an Uber:'. env('APP_URL').'/deliver_via_uber/'.$order->id.'?code='.$accessCode);
                            }
                        }else{ 
                            if($order->customer_phone !== '3109169514'){                                    
                                Twilio::message($order->customer_phone, 'Your order  '.$order->name.' is complete and is preparing for shipping. - '. $companyName);
                            }
                        }
 

                        if($this->isEmptyValue($order->shopify_id) || $this->isEmptyValue($order->etsy_id)){
                            Mail::to($emailToSendTo)->bcc($bcc)->send(new OrderCompleted($user, $order, $this->isUber($order),$accessCode, $type)); 
                        }else{
                            try{
                            Mail::to($order->customer_email)->cc($emailToSendTo)->bcc($bcc)->send(new OrderCompleted($user, $order, $this->isUber($order), $accessCode, $type));
                            }catch (\Exception $e) {
                                return response([
                                    'code' => 400,
                                    'success' => false,
                                    'message' => $e->getMessage()
                                ]);
                            }
                        } 
                        
                        $time = \Carbon\Carbon::now();
                        OrderEmailQueue::updateOrInsert([
                            'order_id' => $order->id,
                            'email_type' => 'OrderCompleted',
                            'is_mail_sent' => 1,
                            'created_at' => $time,
                            'updated_at' => $time
                        ]);
                    }
                }catch(\Exception $e){
                }


                 

                try {

                    /* if(!$order->customer_phone) {
                        return response([
                            'code' => 400,
                            'success' => false,
                            'message' => "Kindly enter valid phone number"
                        ]);
                    } */
                    if($emailQueues == 0){
                        if(isset($request->sms) && $request->sms == 'true') {
                            try {
                                if($order->customer_phone !== '3109169514'){  
                                    Twilio::message($order->customer_phone, 'Your order  '.$order->name.' is complete and is preparing for shipping. - '. $companyName);
                                }
                            }catch(\Exception $e){
                                return response([
                                    'code' => 200,
                                    'success' => false,
                                    'message' => $e->getMessage()
                                ]);
                            }

                        }
                    }
                } catch (\Exception $e) {
                    return response([
                        'code' => 400,
                        'success' => false,
                        'message' => $e->getMessage()
                    ]);
                }

            }

            if($request->post('type') !== null  && $order->resource_id !== null){
                $resource_user = Resource::find($order->resource_id);
                
                /* Mail::to($resource_user->email)->send(new ResourceEmail($order));

                if($resource_user->sms !== null){
                    $accessCodeData = AccessCode::where(['order_id' => $orderID, 'code' => $request->code])->first();
                    Twilio::message($resource_user->sms,$order->customer_phone, 
                        'Order #'. $order->id .'
                        Due '. date('n / j', strtotime($order->arrival_date) ) .'. Thank you.
                        '. env('FRONTEND_URL')."#/resource-view?order_id=".$order->id."&page=resources&code=".$accessCodeData->code);
                } */

                switch($request->post('type')){
                    case "issue":

                        try {
                            if($order->customer_phone !== '3109169514'){  
                                Twilio::message($order->customer_phone, 'There is an issue with your order  '.$order->name.'. Please contact us at 310 916 9514. - '. $companyName);
                            }
                        }catch(\Exception $e){
                        }  
                        
                        ActivityNotif::create([
                            'order_id' => $order->id,
                            'title' => $order->id . " Marked as issue by " . $resource_user->name,
                            'description' => $order->name,
                            'initiated_by' => $resource_user->id,
                            'action' => 'marked_as_with_issues',
                            'type' => 'resources' 
                        ]);    
                    break;
                    case "complete":
                        ActivityNotif::create([
                            'order_id' => $order->id,
                            'title' => $order->id . " Marked Complete by " . $resource_user->name,
                            'description' => $order->name,
                            'initiated_by' => $resource_user->id,
                            'action' => 'marked_as_completed',
                            'type' => 'resources' 
                        ]);      
                        $order->status = 'Completed';
                        $order->trader_printer_id = null;
                        if($order->shopify_id !== null){
                            try {
                                $this->fulfillOrder($order->id);
                            }catch(\Exception $e){
                                return $e->getMessage();
                            }

                        }
                        $order->update();
                    break;
                }
            }
      
            if(isset($request->status)){
                if($request->countlength === 0){
                    switch($request->status){
                        case "completed":
                            $order->status = 'Completed';
                            $order->trader_printer_id = null;
                            switch($order->ship_type){
                                default:
                                    $type = 'shipping';
                                break;
                                case 'pickup':
                                case 'pickup-9am':
                                case 'pickup-5pm':
                                case 'uber':
                                case 'hand_deliver':
                                case null:
                                case '':
                                    $type = 'pickup';
                                break;
                                case 'manually_shipped':
                                    $type = 'manually_shipped';
                                break;
                                case 'Provided Label':
                                    $type = 'provided_label';
                                break;
            
                            }
                            try {

                                //generate access code
                                $accessCode = md5(time());

                                //check to see if order already has an access code
                                if($orderDetails){ 
                                    if($orderDetails->access_code === null){
                                        $orderDetails->update(['access_code' => $accessCode]);
                                    }
                                }

                                $emailQueues = OrderEmailQueue::where('order_id', $order->id)->where('email_type', 'OrderCompleted')->where('is_mail_sent', 1)->count();  
                               
                                if($emailQueues == 0){

                                    /* Twilio::message($order->customer_phone, 'Your order has been completed. Check the link in your email to book or click the link below:'. env('APP_URL').'/deliver_via_uber/'.$order->id.'?code='.$accessCode); */

                                    if($this->isUber($order) == true){ 
                                        if($order->customer_phone !== '3109169514'){   
                                            Twilio::message($order->customer_phone, 
                                            'Your order is ready! Want it delivered to '.$order->customer_address.'? Check your email or click the link below to instantly book an Uber:'. env('APP_URL').'/deliver_via_uber/'.$order->id.'?code='.$accessCode);
                                        }
                                    }else{ 
                                        if($order->customer_phone !== '3109169514'){                                    
                                            Twilio::message($order->customer_phone, 'Your order  '.$order->name.' is complete and is preparing for shipping. - '. $companyName);
                                        }
                                    }

                                    if($this->isEmptyValue($order->shopify_id) || $this->isEmptyValue($order->etsy_id)){
                                        Mail::to($emailToSendTo)->bcc($bcc)->send(new OrderCompleted($user, $order, $this->isUber($order), $accessCode, $type));
                                    }else{
                                        Mail::to($order->customer_email)->cc($emailToSendTo)->bcc($bcc)->send(new OrderCompleted($user, $order, $this->isUber($order), $accessCode, $type));
                                    }
                                    $time = \Carbon\Carbon::now();
                                    OrderEmailQueue::updateOrInsert([
                                        'order_id' => $order->id,
                                        'email_type' => 'OrderCompleted',
                                        'is_mail_sent' => 1,
                                        'created_at' => $time,
                                        'updated_at' => $time
                                    ]);
                                }
                            }catch(\Exception $e){
                                /* return $e; */
                            }
                            try {
                                if($order->customer_phone !== '3109169514'){                                    
                                    Twilio::message($order->customer_phone, 'Your order  '.$order->name.' is complete and is preparing for shipping. - '. $companyName);
                                }
                            }catch(\Exception $e){
                                /* return response([
                                    'code' => 200,
                                    'success' => false,
                                    'message' => $e->getMessage()
                                ]); */
                            }
                            ActivityNotif::create([
                                'order_id' => $order->id,
                                'title' => 'Order Completed  - ' . $order->id,
                                'description' => $order->name,
                                'initiated_by' => $order->created_by,
                                'action' => 'order_completed',
                                'type' => 'order_status' 
                            ]);
                        break;
                        case "incomplete":
                            
                            try {
                                if($this->isEmptyValue($order->shopify_id) || $this->isEmptyValue($order->etsy_id)){
                                    Mail::to($emailToSendTo)->cc($bcc)->send(new OrderInCompleted($user, $order));
                                }else{
                                    Mail::to($emailToSendTo)->cc($emailToSendTo)->bcc($bcc)->send(new OrderInCompleted($user, $order));
                                }
                               
                            }catch(\Exception $e){
                                /* return $e; */
                            }
                            ActivityNotif::create([
                                'order_id' => $order->id,
                                'title' => 'Marked Incomplete  - ' . $order->id,
                                'description' => $order->name,
                                'initiated_by' => $order->created_by,
                                'action' => 'order_incomplete',
                                'type' => 'order_status' 
                            ]);
                        break;
                    }
                }
            } 
             

            if(isset($request->completed) && $request->completed == 'false') {
                $order->status = 'Production';
            }



            if($order->update()) {

                if($order->invoice_number !== null){
                    $queryInvoiceIdData = DB::table('orders')->where('invoice_number', $order->invoice_number)->get(['id']);             
                    $order['invoice_id'] = $queryInvoiceIdData;
                }else{
                    $order['invoice_id'] = null;  
                }
                $userName = DB::table('users')->where('id', $order->customer_id)->get(['first_name','last_name']);
                $order['firstName'] = $userName[0]->first_name;
                $order['lastName'] = $userName[0]->last_name;

                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Order updated.',
                    'data' => $order
                ]);
            } else {
                return response([
                    'code' => 500,
                    'success' => false,
                    'message' => 'Something went wrong, Try again later.'
                ]);
            }
    }    


    public function isUber($order){
        $result = false;
        if($order->ship_type == 'pickup-9am' || $order->ship_type == 'pickup-5pm' || $order->ship_type == 'uber' || $order->ship_type == 'hand_deliver'){
            $result =  true;
        }
        return $result;
    }

    public function updateStatusToProduction($order,$companyName){
        
        $trueCount = 0;
        if($order->status == 'Processing'){
            $trueCount = 0;
            if($order->apparel == 1){ $trueCount++; }
            if($order->film == 1){ $trueCount++; }
            if($order->art_is_sized == 1 || $order->art_is_sized == true){ $trueCount++; }
            if($order->pay == 1 || $order->pay == true || $order->payment_terms == 'true' || $order->payment_terms == '1' ){ $trueCount++; }
            if($trueCount > 3){

                $order->status = 'Production';
                $arrivalDate = date("D,F jS", strtotime($order->arrival_date)); 

                ActivityNotif::create([
                    'order_id' => $order->id,
                    'title' => 'In Production  - ' . $order->id,
                    'description' => $order->name,
                    'initiated_by' => $order->created_by,
                    'action' => 'moved_to_production',
                    'type' => 'order_status' 
                ]);

                $time = \Carbon\Carbon::now();
                OrderEmailQueue::updateOrInsert([
                    'order_id' => $order->id,
                    'email_type' => 'OrderProduction',
                    'created_at' => $time,
                    'updated_at' => $time
                ]); 
/* 
                OrderDetails::updateOrInsert(
                    ['order_id' => $order->id], ['production_start_date' =>  date('Y-m-d', strtotime($order->arrival_date. '-1 day'))],                    
                ); */

                $arrivalDate = \Carbon\Carbon::parse($order->arrival_date);
                $productionStartDate = $arrivalDate->copy()->subDays(1);

                // Check if production start date falls on a Saturday or Sunday
                if ($productionStartDate->isWeekend()) {
                    // Adjust to the previous Friday
                    $productionStartDate->previous(\Carbon\Carbon::FRIDAY); 
                }

                OrderDetails::updateOrInsert(
                    ['order_id' => $order->id], ['production_start_date' =>  $productionStartDate->format('Y-m-d')],                    
                );

                $customer = User::where('id',$order->customer_id)->first();

                if($order->customer_phone !== null && $order->customer_phone !== '3109169514') {
                    $arrivalDate = date('D, F jS', strtotime($order->arrival_date));
                    try {                            
                        if($customer->role  == 'Customer' && $customer->sms_required == 'true' && $customer->contact_number !== '3109169514' ){

                            Twilio::message($order->customer_phone, 'Your order, '.$order->name.'   is in production, with an estimated completion date of '.$arrivalDate.'. - '. $companyName);        
                   
                        } 
                    }catch(\Exception $e){
                        
                    } 
                } 

                if($order->resource_id !== null) {
                    try {
                        $resource_user = Resource::find($order->resource_id);   
                        $OrderEmailQueue = OrderEmailQueue::where('order_id', $order->id)->where('email_type', 'ResourceShippingEmail')->count();                     
                        if($OrderEmailQueue == 0){
                            $time = \Carbon\Carbon::now();
                            OrderEmailQueue::updateOrInsert([
                                'order_id' => $order->id,
                                'email_type' => 'ResourceShippingEmail',
                                'created_at' => $time,
                                'updated_at' => $time
                            ]);
                        }
                        if($resource_user->sms !== null){

                            $accessCodeData = AccessCode::where(['order_id' => $order->id])->first();
                            $resourceList = ResourceShipping::where(['order_id' => $orderId])->whereNotNull('shipping_order_id')->first();
                            if($resourceList){
                                $shippingDetails = "Merchandise is being shipped to you";
                            }else{
                                $shippingDetails = "Merchandise Pickup Location: 4722 S Normandie Ave. LA, CA 90037";
                            }
                            Twilio::message($resource_user->sms, 
                                'Order #'. $order->id .''. "\n\n" .'Due '. date('n / j', strtotime($order->arrival_date) ) .'. Shipping Details'. $shippingDetails .' Thank you.'. "\n" .'
                                '.env('FRONTEND_URL').'#/resource-view?order_id='.$order->id.'&page=resources&code='.$accessCodeData->code);
    
                        }
                    }catch(\Exception $e){
                        /* return "resource email : " . $e->getMessage(); */
                    }
                }

                $emailToSendTo = $order->customer_email;

                if($order->orders_meta->integration_id !== null){ 

                    $shopDetails = ShopifyIntegration::where(['id' => $order->orders_meta->integration_id])->first();

                    switch($shopDetails->integration_type){

                        case "etsy":

                            $shopOwnerEmail = $shopDetails->shop_metadata['user_data']['primary_email'];

                        break;

                        case "shopify":

                            $shopOwnerEmail = $shopDetails->shop_metadata['email'];

                        break;

                    }

                    $emailToSendTo = [$order->customer_email,$shopOwnerEmail];

                }

                
            }
        }
        return $order;

    }

    public function sendQueueEmails($orderId){  
            $emailQueues = OrderEmailQueue::where('order_id', $orderId)->where('is_mail_sent', false)->get();  
             
              $var = [];
              $isPopUpRequired = true;
            foreach ($emailQueues as $key => $emailQueue) { 
                $var[] = $emailQueue->id;                
                $order = Order::find($orderId); 
                $user = User::where('id',$order->created_by)->first();
                if($user->role == 'Trader'){  
                    Config::set('mail',$this->traderMailConfig($user));                 
                } 
                $emailToSendTo = $user->email;
                $customer = User::where('id',$order->customer_id)->first();  
                $bcc=["production@districtprinting.com","notifications@districtprinting.tech"];     
                $getProductionManager = User::where(['production_manager' => 'true'])->first(['email']);
                if($getProductionManager){
                    $bcc=[$getProductionManager->email, "notifications@districtprinting.tech"];
                }     
                if($emailQueue->email_type == 'OrderProduction'){   
                    try {
                        if($this->isEmptyValue($order->shopify_id) || $this->isEmptyValue($order->etsy_id)){
                            Mail::to($user->email)->bcc($bcc)->send(new OrderProduction($user, $order));
                        }else{
                            Mail::to($order->customer_email)->cc($user->email)->bcc($bcc)->send(new OrderProduction($user, $order));
                        } 
                    }catch(\Exception $e){
                        return response([
                            'code' => 400,
                            'success' => false,
                            'message' => 'OrderProduction Email Error : '.$e->getMessage(), 
                            'error' => $e->getMessage()
                        ]);
                    }
                }else if($emailQueue->email_type == 'VendorOrderPlacement'){   
                    try {                        
                        $this->sendVendorPlacingOrderEmail($order, $bcc);
                    }catch(\Exception $e){
                        return response([
                            'code' => 400,
                            'success' => false,
                            'message' => 'VendorOrderPlacement Email Error : '.$e->getMessage(), 
                            'error' => $e->getMessage()
                        ]);
                    }
                }else if($emailQueue->email_type == 'ResourceEmail'){
                    if(($this->isEmpty($order->shopify_id)  || $this->isEmpty($order->etsy_id)) == false ){
                        try {
                            if($order->resource_id){
                                $resource_user = Resource::find($order->resource_id);                            
                                Mail::to($resource_user->email)->cc($user->email)->bcc($bcc)->send(new ResourceEmail($user,$order)); 
                            }    
                        }catch(\Exception $e){
                            return response([
                                'code' => 400,
                                'success' => false,
                                'message' => 'ResourceEmail Email Error : '.$e->getMessage(), 
                                'error' => $resource_user
                            ]);
                        }
                    }
                }else if($emailQueue->email_type == 'ResourceEmailAssign'){
                    if(($this->isEmpty($order->shopify_id)  || $this->isEmpty($order->etsy_id)) == false ){
                        try {
                            if($order->resource_id){
                                $resource_user = Resource::find($order->resource_id);                            
                                Mail::to($resource_user->email)->cc([config('app.notification_email')])->bcc($bcc)->send(new ResourceEmail($user,$order));   
                            }
                        }catch(\Exception $e){
                            return response([
                                'code' => 400,
                                'success' => false,
                                'message' => 'ResourceEmailAssign Email Error : '.$e->getMessage(), 
                                'error' => $e->getMessage()
                            ]);
                        }
                    }
                }else if($emailQueue->email_type == 'ResourcePickUpEmail'){
                    if(($this->isEmpty($order->shopify_id)  || $this->isEmpty($order->etsy_id)) == false ){
                        try {
                            $resource_user = Resource::find($order->resource_id);   
                            $resourceList = ResourceShipping::where(['order_id' => $orderId])->get(['shipping_address']); 
                            $resourceCount = $resourceList->count();

                            if ($resource_user !== null && $resource_user->shipping_email) {
                                $resource_user->email = $resource_user->shipping_email  != 'null' ? $resource_user->shipping_email : $resource_user->email;
                            } 
                            if($resourceList[0]['shipping_address'] == null){
                                $resourceList[0]['shipping_address'] = '4722 S. Normandie LA, CA 90037';
                            } 
                            Mail::to($resource_user->email)->cc([config('app.notification_email')])->bcc($bcc)->send(new ResourcePickUpEmail($order, $resourceList[0]['shipping_address'], $resourceCount,$user)); 
                        /*  Mail::to($resource_user->email)->cc([config('app.notification_email')])->send(new ResourcePickUpEmail($order));   */ 
                        }catch(\Exception $e){
                            return response([
                                'code' => 400,
                                'success' => false,
                                'message' => 'ResourcePickUpEmail Email Error : '.$e->getMessage(), 
                                'error' => $e->getMessage()
                            ]);
                        }
                    }
                }else if($emailQueue->email_type == 'ResourceShippingEmail' || $emailQueue->email_type == 'ResourceSendShippingEmail' 
                || $emailQueue->email_type == 'ResourceShippingEmailNewlyAssigned'){
                    if(($this->isEmpty($order->shopify_id)  || $this->isEmpty($order->etsy_id)) == false ){
                        try {
                            $resource_user = Resource::find($order->resource_id);   
                            $resourceList = ResourceShipping::where(['order_id' => $orderId])->whereNotNull('shipping_order_id')->get(['carriers_code','tracking_number']); 
                            
                            
                            if ($resource_user !== null && $resource_user->shipping_email) { 
                                $resource_user->email = $resource_user->shipping_email != 'null' ? $resource_user->shipping_email : $resource_user->email;
                                 
                            } 
                             
                            
                            $trackingLinks = [];
                            
                            foreach($resourceList as $resource){
                            

                                switch(@$resource->carriers_code){
                                    case "fedex":
                                        $resource->trackingNumber .= 'https://www.fedex.com/fedextrack/?action=track&trackingnumber='.$resource->tracking_number; 
                                    break;
                                    case "stamps_com":
                                        $resource->trackingNumber .= 'https://tools.usps.com/go/TrackConfirmAction.action?tLabels='.$resource->tracking_number;
                                    break;
                                    case "ups_walleted":
                                        $resource->trackingNumber .= 'http://wwwapps.ups.com/WebTracking/processRequest?HTMLVersion=5.0&Requester=NES&AgreeToTermsAndConditions=yes&loc=en_US&tracknum='.$resource->tracking_number;
                                    break;
                                } 

    
                            } 
                            
                            if($order->status == 'Production' && $emailQueue->email_type == 'ResourceShippingEmail'){                                
                                Mail::to($resource_user->email)->cc([config('app.notification_email')])->bcc($bcc)->send(new ResourceShippingEmail($order,   $resourceList,$user));
                            }else if($order->status == 'Production' && $emailQueue->email_type == 'ResourceShippingEmailNewlyAssigned'){                                
                                $trader = User::where('id',$order->trader_printer_id)->first();
                                Mail::to($trader->email)->cc([config('app.notification_email')])->bcc($bcc)->send(new ResourceShippingEmailNewlyAssigned($order,   $resourceList,$user));
                                $message  = 'Hello! You have been assigned a new order:'.$order->name.'Order #'.$order->id.'. Please check your email for order details.';
                                Twilio::message(filter_var($trader->contact_number, FILTER_SANITIZE_NUMBER_INT), $message);
                            }else{
                                $isPopUpRequired = false;
                            } 

                            if($emailQueue->email_type == 'ResourceSendShippingEmail'){
                                
                                Mail::to($resource_user->email)->cc([config('app.notification_email')])->bcc($bcc)->send(new ResourceShippingEmail($order,   $resourceList,$user));
                            } 
                            
                        }catch(\Exception $e){
                            return response([
                                'code' => 400,
                                'success' => false,
                                'message' => 'ResourceShippingEmail Email Error : '.$e->getMessage(), 
                                'error' => $e->getMessage()
                            ]);
                        }
                    }
                }

            }     
            $updateEmailQueue = DB::update('UPDATE order_email_queue SET is_mail_sent = true WHERE order_id = ?', [$orderId]);
 
            if($updateEmailQueue) { 
                if(!$isPopUpRequired){
                    return response([
                        'code' => 201,
                        'success' => true,
                        'message' => ''
                    ]);
                }
                if($updateEmailQueue) {
                    return response([
                        'code' => 200,
                        'success' => true,
                        'message' => 'Email Send successfully.'
                    ]); 
                }   else {
                    return response([
                        'code' => 500,
                        'success' => false,
                        'message' => 'Something went wrong, Try again later.'
                    ]);
                }
            } else {
                return response([
                    'code' => 200,
                    'success' => false,
                    'message' => 'nothing to update'
                ]);
            } 
        
        
    }

    public function sendCronJobQueueEmails(){  
        $emailQueues = OrderEmailQueue::where('is_mail_sent', false)->whereDate('created_at', \Carbon\Carbon::today())->get(); 
        
        $var = [];
        $isPopUpRequired = true;
      foreach ($emailQueues as $key => $emailQueue) { 
          $var[] = $emailQueue->id;   
          $orderId = $emailQueue->order_id;                
          $order = Order::find($orderId); 
          $user = User::where('id',$order->created_by)->first();
          if($user->role == 'Trader'){  
              Config::set('mail',$this->traderMailConfig($user));                 
          } 
          $emailToSendTo = $user->email;
          $customer = User::where('id',$order->customer_id)->first();  
          $bcc=["production@districtprinting.com","notifications@districtprinting.tech"];     
          $getProductionManager = User::where(['production_manager' => 'true'])->first(['email']);
          if($getProductionManager){
              $bcc=[$getProductionManager->email, "notifications@districtprinting.tech"];
          }     
          if($emailQueue->email_type == 'OrderProduction'){   
              try {
                  if($this->isEmptyValue($order->shopify_id) || $this->isEmptyValue($order->etsy_id)){
                      Mail::to($user->email)->bcc($bcc)->send(new OrderProduction($user, $order));
                  }else{
                      Mail::to($order->customer_email)->cc($user->email)->bcc($bcc)->send(new OrderProduction($user, $order));
                  } 
              }catch(\Exception $e){
                  return response([
                      'code' => 400,
                      'success' => false,
                      'message' => 'Email Error : '.$e->getMessage(), 
                      'error' => $e->getMessage()
                  ]);
              }
          }else if($emailQueue->email_type == 'VendorOrderPlacement'){   
              try {                        
                  $this->sendVendorPlacingOrderEmail($order, $bcc);
              }catch(\Exception $e){
                  return response([
                      'code' => 400,
                      'success' => false,
                      'message' => 'Email Error : '.$e->getMessage(), 
                      'error' => $e->getMessage()
                  ]);
              }
          }else if($emailQueue->email_type == 'ResourceEmail'){
              if(($this->isEmpty($order->shopify_id)  || $this->isEmpty($order->etsy_id)) == false ){
                  try {
                      $resource_user = Resource::find($order->resource_id);                            
                      Mail::to($resource_user->email)->cc($user->email)->bcc($bcc)->send(new ResourceEmail($user,$order));   
                  }catch(\Exception $e){
                      return response([
                          'code' => 400,
                          'success' => false,
                          'message' => 'Email Error : '.$e->getMessage(), 
                          'error' => $e->getMessage()
                      ]);
                  }
              }
          }else if($emailQueue->email_type == 'ResourceEmailAssign'){
              if(($this->isEmpty($order->shopify_id)  || $this->isEmpty($order->etsy_id)) == false ){
                  try {
                      $resource_user = Resource::find($order->resource_id);                            
                      Mail::to($resource_user->email)->cc([config('app.notification_email')])->bcc($bcc)->send(new ResourceEmail($user,$order));   
                  }catch(\Exception $e){
                      return response([
                          'code' => 400,
                          'success' => false,
                          'message' => 'Email Error : '.$e->getMessage(), 
                          'error' => $e->getMessage()
                      ]);
                  }
              }
          }else if($emailQueue->email_type == 'ResourcePickUpEmail'){
              if(($this->isEmpty($order->shopify_id)  || $this->isEmpty($order->etsy_id)) == false ){
                  try {
                      $resource_user = Resource::find($order->resource_id);   
                      $resourceList = ResourceShipping::where(['order_id' => $orderId])->get(['shipping_address']); 
                      $resourceCount = $resourceList->count();

                      if ($resource_user !== null && $resource_user->shipping_email) {
                          $resource_user->email = $resource_user->shipping_email ? $resource_user->shipping_email : $resource_user->email;
                      } 
                      if($resourceList[0]['shipping_address'] == null){
                          $resourceList[0]['shipping_address'] = '4722 S. Normandie LA, CA 90037';
                      } 
                      Mail::to($resource_user->email)->cc([config('app.notification_email')])->bcc($bcc)->send(new ResourcePickUpEmail($order, $resourceList[0]['shipping_address'], $resourceCount,$user)); 
                  /*  Mail::to($resource_user->email)->cc([config('app.notification_email')])->send(new ResourcePickUpEmail($order));   */ 
                  }catch(\Exception $e){
                      return response([
                          'code' => 400,
                          'success' => false,
                          'message' => 'Email Error : '.$e->getMessage(), 
                          'error' => $e->getMessage()
                      ]);
                  }
              }
          }else if($emailQueue->email_type == 'ResourceShippingEmail' || $emailQueue->email_type == 'ResourceSendShippingEmail'){
              if(($this->isEmpty($order->shopify_id)  || $this->isEmpty($order->etsy_id)) == false ){
                  try {
                      $resource_user = Resource::find($order->resource_id);   
                      $resourceList = ResourceShipping::where(['order_id' => $orderId])->whereNotNull('shipping_order_id')->get(['carriers_code','tracking_number']); 
                      

                      if ($resource_user !== null && $resource_user->shipping_email) {
                          $resource_user->email = $resource_user->shipping_email ? $resource_user->shipping_email : $resource_user->email;
                      } 

                      
                      $trackingLinks = [];
                      
                      foreach($resourceList as $resource){
                      

                          switch(@$resource->carriers_code){
                              case "fedex":
                                  $resource->trackingNumber .= 'https://www.fedex.com/fedextrack/?action=track&trackingnumber='.$resource->tracking_number; 
                              break;
                              case "stamps_com":
                                  $resource->trackingNumber .= 'https://tools.usps.com/go/TrackConfirmAction.action?tLabels='.$resource->tracking_number;
                              break;
                              case "ups_walleted":
                                  $resource->trackingNumber .= 'http://wwwapps.ups.com/WebTracking/processRequest?HTMLVersion=5.0&Requester=NES&AgreeToTermsAndConditions=yes&loc=en_US&tracknum='.$resource->tracking_number;
                              break;
                          } 


                      } 
                      
                      if($order->status == 'Production' && $emailQueue->email_type == 'ResourceShippingEmail'){
                          
                          Mail::to($resource_user->email)->cc([config('app.notification_email')])->bcc($bcc)->send(new ResourceShippingEmail($order,   $resourceList,$user));
                      }else{
                          $isPopUpRequired = false;
                      } 

                      if($emailQueue->email_type == 'ResourceSendShippingEmail'){
                          
                          Mail::to($resource_user->email)->cc([config('app.notification_email')])->bcc($bcc)->send(new ResourceShippingEmail($order,   $resourceList,$user));
                      } 
                      
                  }catch(\Exception $e){
                      return response([
                          'code' => 400,
                          'success' => false,
                          'message' => 'Email Error : '.$e->getMessage(), 
                          'error' => $e->getMessage()
                      ]);
                  }
              }
          }
          $updateEmailQueue = DB::update('UPDATE order_email_queue SET is_mail_sent = true WHERE order_id = ?', [$orderId]);

          if($updateEmailQueue) { 
            if(!$isPopUpRequired){
                $return[] = response([
                    'code' => 201,
                    'success' => true,
                    'message' => 'isPopUpRequired'
                ]);
            }
            if($updateEmailQueue) {
                $return[] = response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Email Send successfully.'
                ]); 
            }   else {
                $return[] = response([
                    'code' => 500,
                    'success' => false,
                    'message' => 'Something went wrong, Try again later.'
                ]);
            }
        } else {
                $return[] = response([
                'code' => 201,
                'success' => true,
                'message' => ''
            ]);
        } 

      }     
      
      return $return;
  
    
    
}
    public function sendOfflineChatEmail(Request $request){    
                
                $order = Order::find($request->orderId); 
                $user = User::where('id',$order->created_by)->first();       
               if($request->receiverId == $request->senderId){
                $user = User::where('id',str_replace("user","", $request->receiverId))->first();  
               }
                     
                $sender = User::where('id', str_replace("user","", $request->senderId))->first();
                $senderEmail = $sender->email;
                $senderName = $sender->first_name . ' ' . $sender->last_name;             
                
                    try {
                        $bcc=["notifications@districtprinting.tech"]; 
                        Mail::mailer('info')->to($user->email)->cc($senderEmail)->bcc($bcc)->send(new OfflineChatEmail($user, $order, $senderName, $request->chatMassage)); 
                    }catch(\Exception $e){
                        return response([
                            'code' => 400,
                            'success' => false,
                            'message' => 'Email Error', 
                            'error' => $e->getMessage()
                        ]);
                    } 
                    return response([
                        'code' => 200,
                        'success' => true,
                        'message' => 'Email Send successfully'
                    ]);
                
                
             
           
        
    }

    public function OrderIssue(Request $request, $orderId) {
        $order = Order::find($orderId);
        $user = User::where('id',$order->created_by)->first();
        $companyName = "District Printing";
        if($user->role == 'Trader'){  
            $companyName = $user->company_name; 
        } 
        $phoneNumber = "";
        $message = "";

        switch($request->type){
            case "purchasing":
                $phoneNumber = $user->contact_number;
                $message = 'Inventory issue with '.$order->id.' '.$order->name.' for '. $order->customer_name .'.';
            break;
            case "default":
            default:
                $phoneNumber = $order->customer_phone;
                $message = 'There is an issue with your order  '.$order->name.'. Please contact us at 310 916 9514. - '. $companyName;
            break;
        }

        if(!$order) {
            return  response([
                'code' => 404,
                'success' => false,
                'message' => 'No order found',
            ]);
        }

        try {
            if(!$order->customer_phone) {
                return response([
                    'code' => 400,
                    'success' => false,
                    'message' =>'Kindly provide phone number.'
                ]);
            }
            try {
                IssueWithOrder::firstOrCreate([
                    'order_id' => $order->id 
                ]); 
                Twilio::message(filter_var($phoneNumber, FILTER_SANITIZE_NUMBER_INT), $message);
                
            }catch(\Exception $e){
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Order notification sent.',
                    'data' => $order,
                    'error' => $e->getMessage()
                ]);
            }

            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Order notification sent.',
                'data' => $order
            ]);

        } catch (\Exception $e) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => $e->getMessage()
            ]);
        }

    }

 

    public function GetTrackingDetails(Request $request, $orderID, $type = 'normal_request'){

        $guzzle = new Guzzle\Client([
            'base_uri' => 'https://api.aftership.com/v4/',
            'headers' => [ 
                'as-api-key' => env('AFTERSHIP_DEFAULT'),
                'Content-Type' => 'application/json'
            ]
        ]);

        $error = null;
        $status = true;

        //check to see if the order has an aftership data

        switch($request->type){
            case "order_id":
                $orderMeta = OrderMeta::where(['order_id' => $orderID])->first();
                $order = Order::where(['id' => $orderID])->first();
                $orderIdReference = $orderID;
            break;
            case "label":
                $label = PastLabels::where(['id' => $orderID])->first();
                $label->metadata = @json_decode($label->metadata);
                $orderMeta = OrderMeta::where(['order_id' => $label->order_id])->first();
                $order = Order::where(['id' => $label->order_id])->first();
                $orderIdReference = $orderMeta->order_id;
            break;
        }

        if($orderMeta === null){
            OrderMeta::upsert([ 
                'order_id' => $orderID,
                'aftership_data' => '{}'
            ], ['order_id'], ['aftership_data']);

            $orderMeta = OrderMeta::where(['order_id' => $orderID])->first();
        }

        if($orderMeta->aftership_data === null || count((array) json_decode($orderMeta->aftership_data) ) === 0){

            switch($request->type){
                case "order_id":
                    /* if(@$order->tracking_number === null){
                        return ['status' => false];
                    } */
                    $trackingCreation = $guzzle->post('trackings', [
                        'body' => json_encode(['tracking' => [
                            'tracking_number' => $order->tracking_number
                        ]])
                    ]);
                break;
                case "label":
                   /*  if(@$label->metadata->tracking_number === null){
                        return ['status' => false];
                    } */
                    $trackingCreation = $guzzle->post('trackings', [
                        'body' => json_encode(['tracking' => [
                            'tracking_number' => $label->metadata->tracking_number
                        ]])
                    ]);
                break;
            }

            try {
                $trackingDetailsResults = json_decode($trackingCreation->getBody()->getContents());

                OrderMeta::where(['order_id' => $orderIdReference])->update(['aftership_data' => json_encode($trackingDetailsResults)]);

                $shippingId = $trackingDetailsResults->data->tracking->tracking_number;
                $afterShipId = $trackingDetailsResults->data->tracking->id;

            }catch(\Exception $e){
                $trackingDetailsResults = null;
                $error = $e->getMessage();
                $status = false;
            }

        }else{
            $details = json_decode($orderMeta->aftership_data);
            $shippingId = $details->data->tracking->tracking_number;
            $afterShipId = $details->data->tracking->id;
        }

        $shippingStatus = 'Pending';

        $trackingDetailsResults = [];

        try {
            $trackingDetails = $guzzle->get('trackings/'.$afterShipId, [
                'body' => ''
            ]);

            $trackingDetailsResults = json_decode($trackingDetails->getBody()->getContents());

            switch($type){
                case 'foreign_add':
                    return $trackingDetailsResults;
                break;
            }


            if(count($trackingDetailsResults->data->tracking->checkpoints) > 0){
                $shippingStatus =  $trackingDetailsResults->data->tracking->checkpoints[count($trackingDetailsResults->data->tracking->checkpoints)-1]->subtag_message;
            }

            $shippedDate = $trackingDetailsResults->data->tracking->shipment_delivery_date;

            Order::find($orderIdReference)->update([
                'tracking_number' => $shippingId,
                'shipping_des' => $shippingStatus
            ]);
            
/*             $activeNotification = ActivityNotif::where([['order_id','=' ,$orderIdReference],['action', '=' ,'apparel_ordered']])->count();
                if($activeNotification === 0){
                    ActivityNotif::create([
                        'order_id' => $order->id,
                        'title' => 'Apparel Ordered for ' . $order->id,
                        'description' => $order->name,
                        'initiated_by' => $order->created_by,
                        'action' => 'apparel_ordered',
                        'type' => 'admin' 
                    ]);
                }  */
            

        }catch(\Exception $e){
            \Log::emergency('Error: ' . $e->getMessage());
            $error = $e->getMessage();
            $status = false;
        }        

        return ['tracking_status' => $status, 'details' => $trackingDetailsResults, 'error' => $error, 'status' => $shippingStatus, 'order_id' => $orderIdReference];

    }


    public function GetOrderTrackingDetails(Request $request, $orderID, $type = 'normal_request'){

        
        $orderMeta = OrderMeta::where(['order_id' => $orderID])->first(['aftership_data']);
        $order = Order::where(['id' => $orderID])->first();
        $orderIdReference = $orderID; 
    
        $shippingStatus = $order->shipping_des;

        if($order->shipping_des === null){            
            $shippingStatus = 'Pending';
        }

        if($order->tracking_number !== null && $order->shipping_des !== 'Delivered'){  
             
            $guzzle = new Guzzle\Client([
                'base_uri' => 'https://api.aftership.com/v4/',
                'headers' => [ 
                    'as-api-key' => env('AFTERSHIP_DEFAULT'),
                    'Content-Type' => 'application/json'
                ]
            ]);

            $tracking = $guzzle->get('trackings?keyword='.$order->tracking_number); 
                 
            $trackingDetailsResults = json_decode($tracking->getBody()->getContents());        

            $isNewTrackingNumber = false;
            if(!$trackingDetailsResults->data->trackings) {
                    
                $trackingCreation = $guzzle->post('trackings', [
                    'body' => json_encode(['tracking' => [
                        'tracking_number' => $order->tracking_number
                    ]])
                ]);
                $isNewTrackingNumber = true; 
    
                $trackingDetailsResults = json_decode($trackingCreation->getBody()->getContents());
    
            } 
    
             if($isNewTrackingNumber){
                $trackingDetailsResults->data->tracking = $trackingDetailsResults->data->tracking;
             }else{
                $trackingDetailsResults->data->tracking = $trackingDetailsResults->data->trackings[0];
             } 

            if(count($trackingDetailsResults->data->tracking->checkpoints) > 0){
                $shippingStatus =  $trackingDetailsResults->data->tracking->checkpoints[count($trackingDetailsResults->data->tracking->checkpoints)-1]->subtag_message;
            }  

            $order->shipping_des = $shippingStatus;

            
            if($order->shipping_des === 'Delivered'){

                ActivityNotif::create([
                    'order_id' => $order->id,
                    'title' => 'Order Delivered - ' . $order->id,
                    'description' => $order->name,
                    'initiated_by' => $order->created_by,
                    'action' => 'order_delivered',
                    'type' => 'admin' 
                ]);

                try {        

                 /* Label Urls - Start */
                 $labels = PastLabels::where(['order_id' => $orderID, 'type' => 'shipping'])->get();

                 $labelUrls = [];
                 $labelLinks = "";
                 $arrivalDate = date("D,F jS", strtotime($order->arrival_date));
                  
     
                 foreach($labels as $i => $label){
     
                     $metadata = json_decode($label->metadata);
     
                     if(isset($metadata->shipstation)){
     
                         if(@$metadata->shipstation->carrierCode === null){
                             $metadata->shipstation->carrierCode = $metadata->shipstation->carriers_code;
                         }
     
                         switch(@$metadata->shipstation->carrierCode){
                             case "fedex":
                                 $labelUrls[count($labelUrls)] = 'https://www.fedex.com/fedextrack/?action=track&trackingnumber='.$metadata->tracking_number; 
                                 $labelLinks .=  'https://www.fedex.com/fedextrack/?action=track&trackingnumber='.$metadata->tracking_number.' , '; 
                             break;
                             case "stamps_com":
                                 $labelUrls[count($labelUrls)] = 'https://tools.usps.com/go/TrackConfirmAction.action?tLabels='.$metadata->tracking_number;
                                 $labelLinks .= 'https://tools.usps.com/go/TrackConfirmAction.action?tLabels='.$metadata->tracking_number.' , '; 
                             break;
                             case "ups_walleted":
                                 $labelUrls[count($labelUrls)] = 'http://wwwapps.ups.com/WebTracking/processRequest?HTMLVersion=5.0&Requester=NES&AgreeToTermsAndConditions=yes&loc=en_US&tracknum='.$metadata->tracking_number;
                                 $labelLinks .=   'http://wwwapps.ups.com/WebTracking/processRequest?HTMLVersion=5.0&Requester=NES&AgreeToTermsAndConditions=yes&loc=en_US&tracknum='.$metadata->tracking_number.' , '; 
                             break;
                         }
                     }                
                 }
                 /* Label Urls - End */
                
                    $sendMailToCreator = User::where(['id' => $order->created_by])->first();
                    $userToSendTo = User::where(['id' => $order->customer_id])->first();
                    $companyName = "District Printing";
                    if($sendMailToCreator->role == 'Trader'){  
                        Config::set('mail',$this->traderMailConfig($sendMailToCreator));
                        $companyName = $sendMailToCreator->company_name;                  
                    } 
                    $bcc=["notifications@districtprinting.tech"]; 
                    if($this->isEmptyValue($order->shopify_id) || $this->isEmptyValue($order->etsy_id)){
                        Mail::to($sendMailToCreator->email)->bcc($bcc)->send(new OrderShipmentDelivered($userToSendTo,$order,$labelUrls,$sendMailToCreator ));
                    }else{
                        Mail::to($order->customer_email)->cc($sendMailToCreator->email)->bcc($bcc)->send(new OrderShipmentDelivered($userToSendTo,$order,$labelUrls,$sendMailToCreator ));
                    }
                }catch(\Exception $e){
                    
                }

                try {
                    if($order->customer_phone !== '3109169514'){                       
                        Twilio::message($order->customer_phone, 'Your order  has been Delivered. Please check link for updates - '.$companyName.'. Tracking Link: ' .  $labelLinks );
                    }
                    }catch(\Exception $e){
                    }

            }

            $order->update(); 

            $object = (object) array('data' => array ('tracking' => $trackingDetailsResults->data->tracking));
   
            

            $aftershipData = json_encode($object);
            OrderMeta::updateOrInsert(['order_id' => $order->id],['aftership_data' => $aftershipData]);
    
 
        } 

        
        $status = true;
        return ['tracking_status' => $status, 'details' => json_decode($orderMeta->aftership_data),  'status' => $shippingStatus, 'order_id' => $order->id];

    }
    public function GetReceivingPackageTrackingDetails(Request $request, $orderID, $type = 'normal_request'){
       
        $guzzle = new Guzzle\Client([
            'base_uri' => 'https://api.aftership.com/v4/',
            'headers' => [ 
                'as-api-key' => env('AFTERSHIP_DEFAULT'),
                'Content-Type' => 'application/json'
            ]
        ]);

        $error = null;
        $status = true;
        $column = 'purchasing_tracking';

        //check to see if the order has an aftership data

        switch($request->type){
            case "order_id":
                $orderMeta = OrderMeta::where(['order_id' => $orderID])->first();
                /* $order = Order::where(['id' => $orderID])->first(); */
                $orderIdReference = $orderID;
            break; 
        }

        $shippingStatus = 'Pending';
        $purchasingData = $orderMeta->{$column};

        $tracking = $guzzle->get('trackings?keyword='.$request->tracking); 
                 
        $trackingDetailsResults = json_decode($tracking->getBody()->getContents());   
        
        $isNewTrackingNumber = false;
        if(!$trackingDetailsResults->data->trackings) {
                
            $trackingCreation = $guzzle->post('trackings', [
                'body' => json_encode(['tracking' => [
                    'tracking_number' => $request->tracking
                ]])
            ]);
            $isNewTrackingNumber = true; 

            $trackingDetailsResults = json_decode($trackingCreation->getBody()->getContents());

        } 

         if($isNewTrackingNumber){
            $trackingDetailsResults->data->tracking = $trackingDetailsResults->data->tracking;
         }else{
            $trackingDetailsResults->data->tracking = $trackingDetailsResults->data->trackings[0];
         }

     
        if(count($trackingDetailsResults->data->tracking->checkpoints) > 0){
            $shippingStatus =  $trackingDetailsResults->data->tracking->checkpoints[count($trackingDetailsResults->data->tracking->checkpoints)-1]->subtag_message;
        }  
        
        //get the index and data
        if(array_key_exists('tracking_status', $purchasingData)){
          
            foreach($purchasingData['tracking_status'] as $index => $entry) {
                $purchasingData['tracking_status'][$request->num] = $shippingStatus;
            } 

 
        }else{  

            $purchasingData['tracking_status'] = ['','','']; 
               
            foreach($purchasingData['tracking_status'] as $index => $entry) {
                $purchasingData['tracking_status'][$request->num] = $shippingStatus;
            }  

        }
        
        OrderMeta::updateOrInsert(
            ['order_id' => $orderID],
            [$column => json_encode($purchasingData)]
        );
        return ['tracking_status' => $status, 'details' => $trackingDetailsResults, 'error' => $error, 'status' => $shippingStatus, 'order_id' => $orderIdReference,'purchasing_tracking'=> $purchasingData];


       
    }

      
    public function updateReceivingPackageTrackingDetails(){
    
       
        $guzzle = new Guzzle\Client([
            'base_uri' => 'https://api.aftership.com/v4/',
            'headers' => [ 
                'as-api-key' => env('AFTERSHIP_DEFAULT'),
                'Content-Type' => 'application/json'
            ]
        ]);

        $error = null;
        $status = true;
        $column = 'purchasing_tracking';
 

        $orders = Order::select('orders.id', 'orders_meta.purchasing_tracking')
                    ->leftJoin('orders_meta', 'orders.id', '=', 'orders_meta.order_id')->whereNotIn('status',  ['Completed', 'Draft'])->whereNotNull('orders_meta.purchasing_tracking')->get();
       
        foreach($orders as $order){
            $shippingStatus = "";    
            $trackingStatus = null;   
            $trackingData = null;   
            
            foreach($order->purchasing_tracking['data'] as $key => $trackingNumber){   
                 
                $shippingStatus = "Pending"; 
                 if($trackingNumber){          
                    $trackingData[] = $trackingNumber;
                    try{
                        $purchasingData = $order->purchasing_tracking;
                        $tracking = $guzzle->get('trackings?keyword='.$trackingNumber); 
                        $trackingDetailsResults = json_decode($tracking->getBody()->getContents()); 
                        if($trackingDetailsResults->data->trackings){
                            $trackingDetailsResults->data->tracking = $trackingDetailsResults->data->trackings[0];
                            if(count($trackingDetailsResults->data->tracking->checkpoints) > 0){
                                $shippingStatus =  $trackingDetailsResults->data->tracking->checkpoints[count($trackingDetailsResults->data->tracking->checkpoints)-1]->subtag_message;
                            }  
                            $trackingStatus[] = $shippingStatus;   
                        }else{
                            $trackingStatus[] = ""; 
                        }                     
                    }catch(\Exception $e){
                        return ['status' => false, 'message' => $e->getMessage()];
                    }

                   
                 }else{
                    $trackingStatus[] = "";
                    $trackingData[] = "";
                 }
                      
                 $purchasingData['tracking_status'] =  $trackingStatus;
                 $purchasingData['data'] =  $trackingData;
            } 
            OrderMeta::updateOrInsert(
                ['order_id' => $order->id],
                [$column => json_encode($purchasingData)]
            );   
        }
 
        
        return true;
       
    }

    public function UserDetail(Request $request, $userId) {
        $user = User::find($userId);
        if(auth()->user()->role == 'Sales') {
            $user = User::where('created_by', auth()->user()->id)->where('id',$userId)->first();
        }
        if(!$user) {
            return  response([
                'code' => 404,
                'success' => false,
                'message' => 'No user found',
            ]);
        }

        return response([
            'code' => 200,
            'success' => true,
            'message' => 'User detail.',
            'data' => $user
        ]);

    }

    // Update order status
    public function OrderAssignPrinter(Request $request, $orderId) {
        if($request->type === 'in_house') {
            $validator = Validator::make($request->all(), [
                'printer_id' => 'required'
            ]);


            if ($validator->fails()) {
                return response([
                    'code' => 400,
                    'success' => false,
                    'message' => Misc::FirstValidationMessage($validator->errors()),
                    'errors' => $validator->errors()
                ]);
            }
        }else if ($request->type === 'out_side' || $request->type === 'assign_and_email' || $request->type === 'district_printing') {
            $validator = Validator::make($request->all(), [
                'resource_id' => 'required',
            ]);


            if ($validator->fails()) {
                return response([
                    'code' => 400,
                    'success' => false,
                    'message' => Misc::FirstValidationMessage($validator->errors()),
                    'errors' => $validator->errors()
                ]);
            }
        }


        $order = Order::select('orders.*','orders.name AS name',DB::Raw('(CASE 
                WHEN printers.title IS NULL THEN resources.name
                ELSE printers.title
            END) as printer_name'),'orders.id AS id')->with(['order_arts', 'printer'])
        ->leftJoin('printers', 'orders.printer_id', '=', 'printers.id')
        ->leftJoin('resources', 'orders.resource_id', '=', 'resources.id')->where(['orders.id' => $orderId])->first();


        if(!$order) {
            return  response([
                'code' => 404,
                'success' => false,
                'message' => 'No order found',
            ]);
        }




        if(isset($request->printer_id) && !empty($request->printer_id)) {
            $order->printer_id = $request->printer_id;
        }

        if(isset($request->printer_schedule) && !empty($request->printer_schedule)) {
            $order->printer_schedule = $request->printer_schedule;
        }

        if(isset($request->printer_duration) && !empty($request->printer_duration)) {
            $order->printer_duration = $request->printer_duration;
        }

        if(isset($request->print_date) && !empty($request->print_date)) {
            $order->print_date = $request->print_date;
        }

        if(isset($request->printer_id) && !empty($request->printer_id)) {
            $order->printer_id = $request->printer_id;
            $order->resource_id = null;
        }

        if(isset($request->resource_id) && !empty($request->resource_id)) {
            $order->resource_id = $request->resource_id;
            $order->printer_id = null;
        }

        if(isset($request->type) && !empty($request->type)) {
            $order->printer_type = $request->type;

            if ($request->type === 'district_printing'){
                $order->resource_admin  = $request->resource_id;
                $order->printer_id = null;
                $order->resource_id = null;
                 
            }
        }

        if(isset($request->trader_id) && !empty($request->trader_id)) {
            $order->trader_printer_id = $request->trader_id;
            $order->printer_id = null;
            $order->resource_id = null;
            $OrderEmailQueue = OrderEmailQueue::where('order_id', $order->id)->where('email_type', 'ResourceShippingEmailNewlyAssigned')->count();                     
               
            if($OrderEmailQueue == 0){
                $time = \Carbon\Carbon::now();
                OrderEmailQueue::updateOrInsert([
                    'order_id' => $order->id,
                    'email_type' => 'ResourceShippingEmailNewlyAssigned',
                    'created_at' => $time,
                    'updated_at' => $time
                ]);

            } 
        }

        if($request->type === 'clear'){
            $order->trader_printer_id = null;
            $order->printer_id = null;
            $order->resource_id = null;
        }

        if($order->update()) {

            if($request->type === 'out_side' && $order->status === 'Production'){
                $resource = Resource::find($request->resource_id);
                /* Mail::to($resource->email)->cc([config('app.notification_email')])->send(new ResourceEmail($order)); */

                $time = \Carbon\Carbon::now();
                OrderEmailQueue::updateOrInsert([
                    'order_id' => $order->id,
                    'email_type' => 'ResourceEmailAssign',
                    'created_at' => $time,
                    'updated_at' => $time
                ]);

                $accessCodeData = AccessCode::where(['order_id' => $orderId])->first();

                try {
                    $message = 'Order #'. $orderId .''. "\n\n" .' Due '. date('n / j', strtotime($order->arrival_date) ) .'. Thank you.'. "\n" .'
                    '.env('FRONTEND_URL').'#/resource-view?order_id='.$orderId.'&page=resources&code='.$accessCodeData->code;
                    Twilio::message(filter_var($resource->sms, FILTER_SANITIZE_NUMBER_INT), $message);
 
                }catch(\Exception $e){
                    return response([
                        'code' => 500,
                        'success' => false,
                        'message' => $e->getMessage(),                         
                        'error' => $e->getMessage()
                    ]);
                }

            }            

            if($request->type === 'assign_and_email'){
                $resource = Resource::find($request->resource_id);
                /* Mail::to($resource->email)->cc([config('app.notification_email')])->send(new ResourceEmail($order)); */
                $time = \Carbon\Carbon::now();

                $OrderEmailQueue = OrderEmailQueue::where('order_id',$order->id)->where('email_type','ResourceSendShippingEmail')->first();
                if($OrderEmailQueue){
                    $OrderEmailQueue->email_type = 'ResourceSendShippingEmail';
                    $OrderEmailQueue->updated_at = $time;
                    $OrderEmailQueue->is_mail_sent = '0';
                    $OrderEmailQueue->update();
                }else{
                    OrderEmailQueue::updateOrInsert([
                        'order_id' => $order->id,
                        'email_type' => 'ResourceSendShippingEmail',
                        'created_at' => $time,
                        'updated_at' => $time,
                        'is_mail_sent' => '0'
                    ]);
                }
                $accessCodeData = AccessCode::where(['order_id' => $orderId])->first();

                try {
                    $message = 'Order #'. $orderId .''. "\n\n" .' Due '. date('n / j', strtotime($order->arrival_date) ) .'. Thank you.'. "\n" .'
                    '.env('FRONTEND_URL').'#/resource-view?order_id='.$orderId.'&page=resources&code='.$accessCodeData->code;
                    Twilio::message(filter_var($resource->sms, FILTER_SANITIZE_NUMBER_INT), $message); 
 
                }catch(\Exception $e){
                    return response([
                        'code' => 500,
                        'success' => false,
                        'message' => $e->getMessage(),                         
                        'error' => $e->getMessage()
                    ]);
                }
 


            }  
            if($order->invoice_number !== null){
                $queryInvoiceIdData = DB::table('orders')->where('invoice_number', $order->invoice_number)->get(['id']);             
                $order['invoice_id'] = $queryInvoiceIdData;
            }else{
                $order['invoice_id'] = null;
            }
            
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Printer Assigned.',
                'data' => $order
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }

    }



    public function Shipping(Request $request, $orderId) {
        $order = Order::find($orderId);

        if(!$order) {
            return  response([
                'code' => 404,
                'success' => false,
                'message' => 'No order found',
            ]);
        }

        $totalCount = 0;
        for($i = 1; $i <= 5; $i++) {
            if($order['pcs_1_'.$i]) {
                $totalCount += $order['pcs_1_'.$i];
            }
            if($order['pcs_2_'.$i]) {
                $totalCount += $order['pcs_2_'.$i];

            }
            if($order['pcs_3_'.$i]) {
                $totalCount += $order['pcs_3_'.$i];

            }
            if($order['pcs_4_'.$i]) {
                $totalCount += $order['pcs_4_'.$i];
            }

            if($order['xs_'.$i]) {
                $totalCount += $order['xs_'.$i];
            }

            if($order['s_'.$i]) {
                $totalCount += $order['s_'.$i];
            }

            if($order['m_'.$i]) {
                $totalCount += $order['m_'.$i];
            }
            if($order['l_'.$i]) {
                $totalCount += $order['l_'.$i];
            }
            if($order['xxl_'.$i]) {
                $totalCount += $order['xxl_'.$i];
            }
            if($order['xl_'.$i]) {
                $totalCount += $order['xl_'.$i];
            }
            if($order['xxxl_'.$i]) {
                $totalCount += $order['xxxl_'.$i];
            }
        }

        $shipStationResponse = "";

        if(!$order->is_shipping) {
            $user = User::find($order->customer_id);
            try {
                $shipStation = app(\LaravelShipStation\ShipStation::class);

                $address = new \LaravelShipStation\Models\Address();

                $address->name = $order->customer_name;
                $address->city = $order->customer_city;
                $address->company = $order->customer_attn; 
                $address->street2 = $order->customer_address_2;
                $address->street1 = $order->customer_address;
                $address->state = $order->customer_state;
                $address->postalCode = $order->customer_zipcode;
                $address->country = "US";
                $address->phone = $order->customer_phone;

                $item = new \LaravelShipStation\Models\OrderItem();

                $item->lineItemKey = $order->id;
                $item->name = $order->name;
                $item->quantity = $totalCount; // TODO Total Quantity
                $item->unitPrice  = '0.00';
                // $item->warehouseLocation = 'Warehouse A';

                $orderDe = new \LaravelShipStation\Models\Order();

                $orderDe->orderNumber = $order->id;
                $orderDe->orderDate = $order->arrival_date;
                $orderDe->orderStatus = 'awaiting_shipment';
                $orderDe->customerEmail = $user->shipping_email ? $user->shipping_email : $user->email;
                $orderDe->amountPaid = '0.00';
                $orderDe->taxAmount = '0.00';
                $orderDe->shippingAmount = '0.00';
                $orderDe->internalNotes = '...';
                $orderDe->billTo = $address;
                $orderDe->shipTo = $address;
                $orderDe->items[] = $item;

                $shipStationResponse =  $shipStation->orders->post($orderDe, 'createorder');

                /* if(!$order->customer_phone) {
                    return response([
                        'code' => 400,
                        'success' => false,
                        'message' => "Kindly enter valid phone number"
                    ]);
                } */
                if(isset($request->sms) && $request->sms == 'true') {

                    $order->shipped_date = DB::Raw('NOW()');
                    if($order->etsy_id !== null){
                        //get last shipping label
                        $lastLabel = PastLabels::where(['order_id' => $order->id])->first();
                        $metadata = json_decode($lastLabel->metadata);
                        $orderMeta = OrderMeta::where(['order_id' => $order->id])->first();
                        $aftership = json_decode($order->aftership_data);
                        $trackingData = $this->updateEtsyTrackingData($order->id, [
                            'tracking_code' => $metadata->shipstation->trackingNumber,
                            'carrier_name' => $aftership->data->tracking->slug,
                            'send_bcc' => true
                        ]);
                        
                    }
                    
                    $order->update();


                    try {
                        if($order->customer_phone !== '3109169514'){
                            if(!$this->isEmptyValue($order->shopify_id)){
                                Twilio::message($order->customer_phone, 'Your order  '.$order->name.' has been shipped/picked up. - District Printing');
                            }
                        }
                    }catch(\Exception $e){

                    }


                }
            } catch (\Exception $e) {
                return response([
                    'code' => 400,
                    'success' => false,
                    'message' => $e->getMessage()
                ]);
            }
        }

        $order->is_shipping = !$order->is_shipping;
        // $order->status = 'Shipping';
        if($shipStationResponse) {
            $order->shipping_order_id = $shipStationResponse->orderId;
        }

        if($order->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Shipping status successfully updated.',
                'data' => $order
            ]);
        } else {
            return response([
                'code' => 200,
                'success' => false,
                'message' => 'Something went wrong. Try again later'
            ]);
        }
    }


    // Resources list & Order List
    public function GetResourcesAndOrdersList(Request $request, $status) { 
  
        $resources = Resource::with(['orders' => function ($query) use($status){
            if($status == 'ignoreCompleted'){
                $query->whereNotIn('status',  ['Completed', 'Draft']);
            }elseif($status == 'All'){
                $query->where('status', '!=', 'Draft');
            }else{
                $query->where('status', $status);
            }
        }])->where('resources.is_deleted', 0)->get(); 

        foreach($resources as $key => $resource){  
            $filtered = $this->ignoreDuplicateForGroupOrders($resources[$key]['orders']);               
            unset($resources[$key]['orders']);
            $resources[$key]['orders'] =  $filtered;                  
        }
 
           return response([
            'code' => 200,
            'success' => true,
            'message' => 'Resources List.',
            'data' => $resources
        ]);   
    }

    // Trader list & Order List
    public function GetTraderAndOrdersList(Request $request, $status) { 

        if(auth()->user()->role == 'Admin'){

            $trader = User::with(['orders' => function ($query) use($status){
                if($status == 'ignoreCompleted'){
                    $query->whereNotIn('status',  ['Completed', 'Draft']);
                }elseif($status == 'All'){
                    $query->where('status', '!=', 'Draft');
                }else{
                    $query->where('status', $status);
                }
                
            }])->where('users.deleted_at', NULL)->where('users.role', 'Trader')->get();

        }else{
            
            $trader = Printer::with(['orders' => function ($query) use($status){
                if($status == 'ignoreCompleted'){
                    $query->whereNotIn('status',  ['Completed', 'Draft']);
                }elseif($status == 'All'){
                    $query->where('status', '!=', 'Draft');
                }else{
                    $query->where('status', $status);
                }
                
            }])->where('printers.is_deleted', 0)->where('printer_created_by', auth()->user()->id)->get();
        }
 
        foreach($trader as $key => $traderOrder){  
            $filtered = $this->ignoreDuplicateForGroupOrders($trader[$key]['orders']);               
            unset($trader[$key]['orders']);
            $trader[$key]['orders'] =  $filtered;                  
        }
        
           return response([
            'code' => 200,
            'success' => true,
            'message' => 'Trader List.',
            'data' => $trader
        ]);   
    }


        // Trader list & Resource List
        public function GetTraderAndResourceList() { 
           /*  $printerAndTrader[] = ""; */
            if(auth()->user()->role == 'Admin'){
                $createdById = User::where('role', 'Admin')->get('id');
                $printerAndTrader[] = Resource::where('resources.is_deleted', 0)->get(['id','name','order_type']);
    
                $printerAndTrader[] = User::where('users.deleted_at', NULL)->where('users.role', 'Trader')->get(['id','company_name']);

                $printerAndTrader[] = Printer::where('printers.is_deleted', 0)->whereIn('printer_created_by', $createdById)->get(['id','title']);
            }else if(auth()->user()->role == 'Trader'){
                $printerAndTrader[] = Printer::whereIsDeleted(0)->where('printer_created_by', auth()->user()->id)->get(['id','title']);
    
                 
            }else{

            }
 
               return response([
                'code' => 200,
                'success' => true,
                'message' => 'Trader & Resource List.',
                'data' => $printerAndTrader
                ]);   
        }

        // Trader list  
        public function GetTraderList() { 
            $printerAndTrader = User::where('users.deleted_at', NULL)->where('users.role', 'Trader')->get(['id','company_name']);
   
 
               return response([
                'code' => 200,
                'success' => true,
                'message' => 'Trader   List.',
                'data' => $printerAndTrader
                ]);   
        }
    
        // Show Admin to Assign Orders
        public function traderAssignOrderToAdmin(Request $request, $status) {
            $createdById = User::where('created_by', auth()->user()->id)->pluck('id');
            $createdById[] = auth()->user()->id;
            $trader = User::with(['tradeOrders'  => function ($query) use($status, $createdById){
                if($status == 'ignoreCompleted'){
                    $query->whereNotIn('status',  ['Completed', 'Draft'])->whereIn('orders.created_by', $createdById);
                }elseif($status == 'All'){
                    $query->where('status', '!=', 'Draft')->whereIn('orders.created_by', $createdById);
                }else{
                    $query->where('status', $status)->whereIn('orders.created_by', $createdById);
                }
            }])->where('users.email', 'andrew@districtprinting.com')->get(); 
            
            
            foreach($trader as $key => $tradeOrder){  
                $filtered = $this->ignoreDuplicateForGroupOrders($trader[$key]['orders']);               
                unset($trader[$key]['orders']);
                $trader[$key]['orders'] =  $filtered;                  
            }

            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Admin',
                'data' => $trader
            ]);   
        }

        // Printers list & Order List
        public function GetPrintersAndOrdersList(Request $request, $status) {
         
            $user = User::where('role','Admin')->get('id');
            
            $printers = Printer::with(['orders' => function ($query) use($status){
                if($status == 'ignoreCompleted'){
                    $query->whereNotIn('status',  ['Completed', 'Draft']);
                }elseif($status == 'All'){
                    $query->where('status', '!=', 'Draft');
                }else{
                    $query->where('status', $status);
                }
                
            }])->where('printers.is_deleted', 0)->whereIn('printers.printer_created_by', $user)->get();
             
            

            foreach($printers as $key => $printer){  
                $filtered = $this->ignoreDuplicateForGroupOrders($printers[$key]['orders']);               
                unset($printers[$key]['orders']);
                $printers[$key]['orders'] =  $filtered;                  
            }
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Printer List.',
                'data' => $printers
            ]); 
         }


        // Get Printers list for Analytics Page
        public function GetPrintersListForAnalytics(Request $request) {

            
            $user = User::where('role', 'Admin')->pluck('id'); 
            
            $now = \Carbon\Carbon::now();
            if($request->selectedPeriodValue == 'today'){ 
                $startOfWeek =  $endOfWeek  = \Carbon\Carbon::today(); 
            }else if($request->selectedPeriodValue == 'tomorrow'){ 
                $startOfWeek =  $endOfWeek  = \Carbon\Carbon::today()->addDays(1); 
            }else if($request->selectedPeriodValue == 'next_week'){ 
                $startOfWeek = $now->copy()->weekday(\Carbon\Carbon::MONDAY)->addWeeks(1);
                $endOfWeek = $now->copy()->weekday(\Carbon\Carbon::FRIDAY)->addWeeks(1);
            }else if($request->selectedPeriodValue == 'latest'){ 
                $startOfWeek = \Carbon\Carbon::today()->subDays(10000);   
                $endOfWeek = \Carbon\Carbon::today()->addDays(10000); 
            }else{
                $startOfWeek = $now->copy()->weekday(\Carbon\Carbon::MONDAY);
                $endOfWeek = $now->copy()->weekday(\Carbon\Carbon::FRIDAY);
            }

            
            $printers = Printer::with(['orders' => function ($query) use ($request, $startOfWeek, $endOfWeek) {
    /*             $query->where('status', $status)
                      ->whereBetween('production_start_date', [$startOfWeek->format('Y-m-d'), $endOfWeek->format('Y-m-d')]); */

                
                if ($request->has('status') && !empty($request->status)) {
                    $query->where('status', $request->status);
                }  

                if ($startOfWeek && $endOfWeek) {
                    $query->whereBetween('production_start_date', [$startOfWeek->format('Y-m-d'), $endOfWeek->format('Y-m-d')]);
                }
                
            }])
            ->select('id', 'title')
            ->where('printers.is_deleted', 0);


            if ($request->has('selectedPrinterValue') && !empty($request->selectedPrinterValue)) {
                $printers->where('printers.id', $request->selectedPrinterValue); // Filter by printer_id
            } else {
                $printers->whereIn('printers.printer_created_by', $user); // Filter by printer_created_by
            }
            
            $printers = $printers->get();
            
 
            
            $data = [
                'dayWise' => [
                    'day' => ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday'],
                    'orderIds' => [],
                    'totalOrders' => [],
                    'orderPlacement' => [],
                    'dayTimePerPrint' => [],
                    'dayTimePerOrder' => [],
                    'printerName' => [],
                    'printerTotalOrder' => [],
                    'printerPlacement' => [],
                    'printerTimePerPrint' => [],
                    'printerTimePerOrder' => [],
                    'printerOrderIds' => [],
                    
                ],
                'printer' => []
            ];
            
            foreach ($data['dayWise']['day'] as $day) {
                $data['dayWise']['totalOrders'][$day] = 0;
                $data['dayWise']['orderPlacement'][$day] = 0;
                $data['dayWise']['dayTimePerPrint'][$day] = 0;
                $data['dayWise']['dayTimePerOrder'][$day] = 0;
            }
             
            foreach ($printers as $printer) {
                foreach ($printer->orders as $order) {
                    $data['orders'][] = $order;
                    /* $date = \Carbon\Carbon::parse($order->production_start_date)->format('l'); */

                    $dates = \Carbon\Carbon::parse($order->production_start_date);

                    // Adjust date to Friday if it's Saturday or Sunday
                    if ($dates->isWeekend()) {
                        $dates->previous(\Carbon\Carbon::FRIDAY);  // Go to the previous Friday
                    }
                    $date = $dates->format('l'); // Get the day name (Monday - Friday)
        
 
                    $printerName = $printer->title;
            
                    if (!isset($data['printer'][$printerName])) {
                        $data['printer'][$printerName] = [
                            'totalOrders' => 0,
                            'orderPlacement' => 0,
                            'dayTimePerPrint' => 0,
                            'dayTimePerOrder' => 0,
                            'printerTimePerPrint' => 0,
                            'printerTimePerOrder' => 0,
                        ];
                    }
            
                    $placements = (is_numeric($order->placements)) ? intval($order->placements) : $order->placements;
                    if($order->full_color_count == 'full_color') {
                        $order->full_color_count = 7;
                    }
                    $full_color_count = (is_numeric($order->full_color_count)) ? intval($order->full_color_count) : $order->full_color_count;
                    $totalCount = $order->total_product_count * $placements;
                    $totalplacement = $full_color_count * $placements;
                    
                    $data['dayWise']['totalOrders'][$date] += $totalCount;
                    $data['dayWise']['orderIds'][$date][] = $order->id;
                    $data['printer'][$printerName]['totalOrders'] += $totalCount;
                    $data['dayWise']['printerOrderIds'][$printerName][] = $order->id;
            
                    $data['dayWise']['orderPlacement'][$date] += $totalplacement;
                    $data['printer'][$printerName]['orderPlacement'] += $totalplacement;

                    $perPrintArray = $this->calculateProductionTime($order->type, $order->total_product_count, $placements, $full_color_count);
 
                    if (isset($perPrintArray['timePerPrint'])) {
                        $data['dayWise']['dayTimePerPrint'][$date] += round($perPrintArray['timePerPrint'], 2);
                        $data['printer'][$printerName]['printerTimePerPrint'] += round($perPrintArray['timePerPrint'], 2);
                    }
                    $data['dayWise']['dayTimePerOrder'][$date] += round($perPrintArray['totalTimeHours'], 2);
 
                    $data['printer'][$printerName]['printerTimePerOrder'] += round($perPrintArray['totalTimeHours'], 2);
                   
                }
            }
            
            // Convert dayWise arrays to comma-separated strings
            foreach (['totalOrders', 'orderPlacement','dayTimePerPrint','dayTimePerOrder'] as $key) {
                $data['dayWise'][$key] = implode(',', array_values($data['dayWise'][$key]));
            }
            
            // Prepare printer data
            foreach ($data['printer'] as $name => $values) {
                $data['dayWise']['printerName'][] = $name;
                $data['dayWise']['printerTotalOrder'][] = $values['totalOrders'];
                $data['dayWise']['printerPlacement'][] = $values['orderPlacement'];
                $data['dayWise']['printerTimePerPrint'][] = $values['printerTimePerPrint'];
                $data['dayWise']['printerTimePerOrder'][] = $values['printerTimePerOrder'];
                /* $data['dayWise']['timePerPrint'][] = $values['timePerPrint']; */
            }
            
            // Convert printer arrays to comma-separated strings
            foreach (['printerTotalOrder', 'printerPlacement','printerTimePerPrint','printerTimePerOrder'] as $key) {
                $data['dayWise'][$key] = implode(',', $data['dayWise'][$key]);
            }
            
            unset($data['printer']); // Remove the old printer data structure.
            
            return $data;

        }


        /* code - Start */
        
        public function calculateProductionTime($orderType, $orderQuantity, $placements, $colors = 0, $stitches = 0) {
 

            $results = [];

            switch ($orderType) {
                case 'screen_printing':
                case 'screen_and_dtg':
                case 'screen_and_dtf':
                case 'screen_and_embroidery': 
                    $baseTimePerPrint = 10;
                    $additionalTimePerColor = 5;
                    $baseSetupTime = 5 * 60;
                    $additionalSetupTimePerColor = 5 * 60;

                    $timePerPrint = $baseTimePerPrint + ($colors - 1) * $additionalTimePerColor;
                    $setupTimePerPlacement = $baseSetupTime + ($colors - 1) * $additionalSetupTimePerColor;

                    $totalPrintTime = $orderQuantity * $placements * $timePerPrint;
                    $totalSetupTime = $placements * $setupTimePerPlacement;
                    $totalTimeSeconds = $totalPrintTime + $totalSetupTime;
                    $totalTimeHours = $totalTimeSeconds / 3600;

                    $results = [
                        'timePerPrint' => $timePerPrint,
                        'setupTimePerPlacement' => $setupTimePerPlacement,
                        'totalPrintTime' => $totalPrintTime,
                        'totalSetupTime' => $totalSetupTime,
                        'totalTimeSeconds' => $totalTimeSeconds,
                        'totalTimeHours' => $totalTimeHours,
                    ];
                    break;

                case 'embroidery':
                    $timePerStitch = 0.1;
                    $stitches = isset($stitches) ? $stitches : 0;
                    $totalStitchTime = $orderQuantity * $stitches * 1000 * $timePerStitch;
                    $totalTimeSeconds = $totalStitchTime;
                    $totalTimeHours = $totalTimeSeconds / 3600;

                    $results = [
                        'timePerStitch' => $timePerStitch,
                        'totalStitchTime' => $totalStitchTime,
                        'totalPrintTime' => $totalStitchTime,
                        'totalTimeSeconds' => $totalTimeSeconds,
                        'totalTimeHours' => $totalTimeHours,
                    ];
                    break;

                case 'direct_to_garment':
                    $timePerPrint = 30;

                    $totalPrintTime = $orderQuantity * $placements * $timePerPrint;
                    $totalTimeSeconds = $totalPrintTime;
                    $totalTimeHours = $totalTimeSeconds / 3600;

                    $results = [
                        'timePerPrint' => $timePerPrint,
                        'totalPrintTime' => $totalPrintTime,
                        'totalTimeSeconds' => $totalTimeSeconds,
                        'totalTimeHours' => $totalTimeHours,
                    ];
                    break;

                case 'dtf':
                    $timePerPrint = 45;

                    $totalPrintTime = $orderQuantity * $placements * $timePerPrint;
                    $totalTimeSeconds = $totalPrintTime;
                    $totalTimeHours = $totalTimeSeconds / 3600;

                    $results = [
                        'timePerPrint' => $timePerPrint,
                        'totalPrintTime' => $totalPrintTime,
                        'totalTimeSeconds' => $totalTimeSeconds,
                        'totalTimeHours' => $totalTimeHours,
                    ];
                    break;

                case 'vinyl':
                    $timePerPrint = 60;

                    $totalPrintTime = $orderQuantity * $placements * $timePerPrint;
                    $totalTimeSeconds = $totalPrintTime;
                    $totalTimeHours = $totalTimeSeconds / 3600;

                    $results = [
                        'timePerPrint' => $timePerPrint,
                        'totalPrintTime' => $totalPrintTime,
                        'totalTimeSeconds' => $totalTimeSeconds,
                        'totalTimeHours' => $totalTimeHours,
                    ];
                    break;

                case 'dyesub':
                    $timePerPrint = 50;

                    $totalPrintTime = $orderQuantity * $placements * $timePerPrint;
                    $totalTimeSeconds = $totalPrintTime;
                    $totalTimeHours = $totalTimeSeconds / 3600;

                    $results = [
                        'timePerPrint' => $timePerPrint,
                        'totalPrintTime' => $totalPrintTime,
                        'totalTimeSeconds' => $totalTimeSeconds,
                        'totalTimeHours' => $totalTimeHours,
                    ];
                    break;

                default:
                    $timePerPrint = 0;

                    $totalPrintTime = $orderQuantity * $placements * $timePerPrint;
                    $totalTimeSeconds = $totalPrintTime;
                    $totalTimeHours = $totalTimeSeconds / 3600;

                    $results = [
                        'timePerPrint' => $timePerPrint,
                        'totalPrintTime' => $totalPrintTime,
                        'totalTimeSeconds' => $totalTimeSeconds,
                        'totalTimeHours' => $totalTimeHours,
                    ];
                    break;
            }

            return $results;
        }

        

 
        /* code - End */
        
         public function ignoreDuplicateForGroupOrders($orders){
            $dataToReturn['data'] = $orders; 
           
            $getGroupIds = array();
            foreach($dataToReturn['data'] as $i => $data){
                if(isset($dataToReturn['data'][$i]['product_group_id'])){
                    $getGroupIds[] = $dataToReturn['data'][$i]['product_group_id'];
                    $getOrderIds[$dataToReturn['data'][$i]['product_group_id']] = $dataToReturn['data'][$i]['id'];
                }
            } 
            
            $batchOrders = OrderDetails::select('product_group_id', DB::raw('GROUP_CONCAT(order_id  SEPARATOR ", ") as ids'))
            ->leftJoin('orders','orders.id','=','order_details.order_id')  
            ->whereIn('product_group_id', $getGroupIds)
            ->where('orders.status', 'Production')
            ->groupBy('product_group_id')
            ->get(); 
            $filterData = array();
            foreach($dataToReturn['data'] as $i => $data){
                if(isset($dataToReturn['data'][$i]['product_group_id'])){
                    foreach($batchOrders as $j => $details){
                        if($details['product_group_id'] == $dataToReturn['data'][$i]['product_group_id']){

                            $batchedOrderCount = count(explode(', ',$details['ids']));
                            if($batchedOrderCount > 1){
                                $dataToReturn['data'][$i]['group_id'] = $details['ids'];
                            }else{
                                $dataToReturn['data'][$i]['product_group_id'] = null;
                            }
                            foreach($getOrderIds as $getOrderId){
                                if($getOrderId == $dataToReturn['data'][$i]['id']){
                                    $filterData[] = $dataToReturn['data'][$i];
                                } 
                            } 
                        }                        
                    }
                }else{
                    $filterData[] = $dataToReturn['data'][$i];
                }
            }
            return $filterData;
         }
        // Printers list & Order List
        public function GetPrintersAndOrdersListInProduction(Request $request, $status = 'Null') {
               
            /*  $printers = Printer::with('orders.printer')->where('printers.is_deleted', 0)->get(); */
             $printers = Printer::with(['orders'  => function ($query) use($status){ 
                     $query->where('status', 'Production');  
             }])->where('printers.is_deleted', 0)->get();

             $idsToFetch = [];

             foreach($printers as $printer){
                if($printer->orders){
                    foreach($printer->orders as $print){
                        if($print->id){    
                            $idsToFetch[count($idsToFetch)] = $print->id;
                        }
                    }
                }                 
             }

             $orderDeployments = OrderDeployment::whereIn('order_id',$idsToFetch)->get();


            $cartArray = [];
             foreach($orderDeployments as $orderDeployment){
                $cartArray[$orderDeployment->order_id] = $orderDeployment;
             }
              
              
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Printer List.',
                'cart' => $cartArray,
                'data' => $printers
            ]); 
          }
    //get Resources List
    public function GetResourcesList(Request $request) {
        $resources = Resource::whereIsDeleted(0)->orderBy('email', 'asc')->get();
        return response([
            'code' => 200,
            'success' => true,
            'message' => 'Resources List.',
            'data' => $resources
        ]);
    } 

    //get deployment by Id
    public function getDeploymentById(Request $request, $id) {
        $orderDeployment = OrderDeployment::where('order_id', $id)->get();
        return response([
            'code' => 200,
            'success' => true,
            'message' => 'Deployment List.',
            'data' => $orderDeployment
        ]);
    } 

    public function getDeploymentByIdList(Request $request) {
        $orderDeployment = OrderDeployment::whereIn('order_id', $request)->get();
        return response([
            'code' => 200,
            'success' => true,
            'message' => 'Deployment List.',
            'data' => $orderDeployment
        ]);
    } 

    //get All Active deployment list
    public function getDeploymentList($status = 'Null') {
       $orderDeployments = OrderDeployment::whereIn('cart_status', ['Deployed','atStation'])->orWhereNull('cart_status')->get(); 
         
       $cartArray = [];
       foreach($orderDeployments as $orderDeployment){
          $cartArray[] = $orderDeployment->order_id;
       }

       $order = Order::whereIn('id',$cartArray)->get();

       $orderArray = [];
       $count = 0;
       foreach($order as $otr){

        foreach($orderDeployments as $orderDeployment){
            if($orderDeployment->order_id == $otr->id){
                $orderArray[$count] = $otr;
                $orderArray[$count]['is_queue'] = $orderDeployment->is_queue;
                $orderArray[$count]['cart_id'] = $orderDeployment->cart_id;
                $orderArray[$count]['cart_status'] = $orderDeployment->cart_status;
                $orderArray[$count]['queue_id'] = $orderDeployment->queue_id;
                $orderArray[$count]['printer_cart_id'] = $orderDeployment->printer_cart_id;
            } 
         }

         $count++;
        }
 
        return response([
            'code' => 200,
            'success' => true,
            'message' => 'Deployment List.',
            'data' => $order,
            'cart'=> $orderArray,
        ]);
    } 

    public function updateDeployment(Request $request, $id) {
        $orderDeployment = OrderDeployment::where('order_id', $id)->first();
        $cartStatus = "atStation";
        $queueStatus = "false";  
        if($request->previous_id){
            try{
                $deleteDeploy = OrderDeployment::where('order_id',$request->previous_id);
                $deleteDeploy->delete();
                 
            }catch(\Exception $e){
            return ['status' => false, 'message' => $e->getMessage()];
            }           

        }

        if($orderDeployment){
 
            $anyOrderAtStation = OrderDeployment::where('cart_status','atStation')->count();
            if($anyOrderAtStation > 0){
                $cartStatus = "Deployed";
                $queueStatus = "true";
            } 

            if($request->assignCartNumber == true){
                $cartStatus = "AssignCartNumber";
                $queueStatus = "true";
            } 
 
                $orderDeployment->cart_id = $request->cartId;
                $orderDeployment->printer_id = $request->printerId;
                $orderDeployment->printer_cart_id = $request->printer_cart_id;
                $orderDeployment->cart_status = $cartStatus;
                $orderDeployment->is_queue = $queueStatus;
                $orderDeployment->update();
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'deployment updated.',
                    'data' => $orderDeployment
                ]);
             
        }else{ 

            $isQueue = 0;
            $isQueue = OrderDeployment::where('is_queue', 'true')->count();

            $orderDeployment = OrderDeployment::create([
                'order_id' => $id,
                'cart_id' => $request->cartId,
                'robot_id' => "1",
                'printer_id' => $request->printerId,
                'printer_cart_id' => $request->printer_cart_id,
                'is_queue' => "true",
                'cart_status' =>  "AssignCartNumber",
                'queue_id' => $isQueue,
            ]);
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'deployment created.',
                'data' => $orderDeployment
            ]);
        }

    } 

    public function returnDeployment($id){
        $orderDeployment = OrderDeployment::where('order_id',$id);
       
        if(!$orderDeployment) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'order deployment details not found.'
            ]);
        }
        
        if($orderDeployment->delete()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'order deployment details deleted.'
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
     }

     public function clearQueue(){
 
        $orderDeployment = OrderDeployment::where('cart_status','Deployed');
       
        


        if(!$orderDeployment) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'order deployment details not found.'
            ]);
        }
        
        if($orderDeployment->delete()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'order deployment details deleted.'
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
     }

    public function updateDeploymentCartQueue(Request $request){
        
       if($request->data_position) {
            foreach($request->data_position as $key => $orderId) {               
            
                $orderData = OrderDeployment::where('order_id', $orderId)->first();            
                $orderData->queue_id = $key;                
                $orderData->save();
                
            }
        
        } 
        return "true";
        /* $orderDeployment = OrderDeployment::where('is_queue', 'true')->get();

        return $orderDeployment; */

    }

    public function CreateResource(Request $request) {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email|unique:resources',
            'name' => 'required'  
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $resource = new Resource;

        $resource->name = $request->name;
        $resource->email = $request->email;
        $resource->order_type = $request->dataType;
        $resource->other_desc = $request->other_desc;
        $resource->shipping_firstname = $request->shipping_firstname;
        $resource->shipping_lastname = $request->shipping_lastname;
        $resource->shipping_company = $request->shipping_company;
        $resource->shipping_address = $request->shipping_address;
        $resource->shipping_street_appartment = $request->shipping_street_appartment;
        $resource->shipping_phone = $request->shipping_phone;
        $resource->shipping_city = $request->shipping_city;
        $resource->shipping_state = $request->shipping_state;
        $resource->shipping_zipcode = $request->shipping_zipcode;
        $resource->shipping_email = $request->shipping_email;

        if($request->profile_image != 'undefined' && $request->profile_image) {
            $folder = '/resource/profile_image';
            $fileName = Misc::GenerateToken(10).'.'.$request->profile_image->getClientOriginalExtension();            
            $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->profile_image, $fileName, 'public'); 
            $resource->profile_image = env('AWS_URL').$uploadPath;
            $extension = $request->profile_image->getClientOriginalExtension();
            if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                $thumb_tmp_path="../storage/tmp/". $fileName;
                $this->resize_crop_image(150,   $request->profile_image, $thumb_tmp_path);
                $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                $resource->profile_image = env('AWS_URL') . $uploadThumbnailPath; 
                unlink($thumb_tmp_path);
            }
        } 

        if($resource->save()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Resource Added.',
                'data' => $resource
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }

    }

    public function CreateVendor(Request $request) {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
         
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $vendor = new Vendor;

        $vendor->first_name = $request->first_name;
        $vendor->last_name = $request->last_name;
        $vendor->email = $request->email;  
        $vendor->vendor_name = $request->vendor_name;
        $vendor->vendor_email = $request->vendor_email; 
        $vendor->vendor_sms = $request->vendor_sms; 
        $vendor->company = $request->company;
        $vendor->address = $request->address;
        $vendor->address_2 = $request->address_2;
        $vendor->phone = $request->phone;
        $vendor->city = $request->city;
        $vendor->state = $request->state;
        $vendor->zipcode = $request->zipcode;

        if($request->profile_image != 'undefined' && $request->profile_image) {
            $folder = '/vendor/profile_image';
            $fileName = Misc::GenerateToken(10).'.'.$request->profile_image->getClientOriginalExtension();            
            $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->profile_image, $fileName, 'public'); 
            $vendor->profile_image = env('AWS_URL').$uploadPath;
            $extension = $request->profile_image->getClientOriginalExtension();
            if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                $thumb_tmp_path="../storage/tmp/". $fileName;
                $this->resize_crop_image(150,   $request->profile_image, $thumb_tmp_path);
                $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                $vendor->profile_image = env('AWS_URL') . $uploadThumbnailPath; 
                unlink($thumb_tmp_path);
            }
        } 

        if($vendor->save()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Vendor Added.',
                'data' => $vendor
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }

    }
    public function UpdateResource(Request $request, $id) {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'name' => 'required',
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $resource = Resource::find($id);
        if(!$resource) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'Resource not found.'
            ]);
        }
        $resource->name = $request->name;
        $resource->email = $request->email;
        $resource->order_type = $request->dataType;
        $resource->other_desc = $request->other_desc;
        $resource->sms = $request->sms;
        $resource->shipping_firstname = $request->shipping_firstname;
        $resource->shipping_lastname = $request->shipping_lastname;
        $resource->shipping_company = $request->shipping_company;
        $resource->shipping_address = $request->shipping_address;
        $resource->shipping_street_appartment = $request->shipping_street_appartment;
        $resource->shipping_phone = $request->shipping_phone;
        $resource->shipping_city = $request->shipping_city;
        $resource->shipping_state = $request->shipping_state;
        $resource->shipping_zipcode = $request->shipping_zipcode;
        $resource->shipping_email = $request->shipping_email;
        if($request->profile_image !== 'null') {
               
            if($request->isImageValid == 'true') {
               $folder = '/resource/profile_image';
               $fileName = Misc::GenerateToken(10).'.'.$request->profile_image->getClientOriginalExtension();
               
               $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->profile_image, $fileName, 'public');
                               
                  
               $resource->profile_image = env('AWS_URL').$uploadPath; 
               $extension = $request->profile_image->getClientOriginalExtension();
               if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                    $thumb_tmp_path="../storage/tmp/". $fileName;
                    $this->resize_crop_image(150,   $request->profile_image, $thumb_tmp_path);
                    $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                    $resource->profile_image = env('AWS_URL') . $uploadThumbnailPath; 
                    unlink($thumb_tmp_path);
                }
               
            }           
        
       } 

        if($resource->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Resource updated.',
                'data' => $resource
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }

    }
    public function UpdateVendor(Request $request, $id) {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email'
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $vendor = Vendor::find($id);
        if(!$vendor) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'Resource not found.'
            ]);
        }
        $vendor->first_name = $request->first_name;
        $vendor->last_name = $request->last_name;
        $vendor->email = $request->email;  
        $vendor->vendor_name = $request->vendor_name;
        $vendor->vendor_email = $request->vendor_email; 
        $vendor->vendor_sms = $request->vendor_sms; 
        $vendor->company = $request->company;
        $vendor->address = $request->address;
        $vendor->address_2 = $request->address_2;
        $vendor->phone = $request->phone;
        $vendor->city = $request->city;
        $vendor->state = $request->state;
        $vendor->zipcode = $request->zipcode;
        if($request->profile_image !== 'null') {
               
            if($request->isImageValid == 'true') {
               $folder = '/vendor/profile_image';
               $fileName = Misc::GenerateToken(10).'.'.$request->profile_image->getClientOriginalExtension();
               
               $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->profile_image, $fileName, 'public');
                               
                  
               $vendor->profile_image = env('AWS_URL').$uploadPath; 
               $extension = $request->profile_image->getClientOriginalExtension();
               if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                    $thumb_tmp_path="../storage/tmp/". $fileName;
                    $this->resize_crop_image(150,   $request->profile_image, $thumb_tmp_path);
                    $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                    $vendor->profile_image = env('AWS_URL') . $uploadThumbnailPath; 
                    unlink($thumb_tmp_path);
                }
               
            }           
        
       } 

        if($vendor->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'vendor updated.',
                'data' => $vendor
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }

    }

    public function UpdateResourceIsPrimary(Request $request, $id) {
         
 

        $resource = Resource::find($id);
        if(!$resource) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'Resource not found.'
            ]);
        } 
        $resource->isPrimary = $request->isPrimary; 

        if($resource->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Resource updated.',
                'data' => $resource
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }

    }
    
    public function UpdateVendorSubFields(Request $request, $id, $field) {
         
 

        $Vendor = Vendor::find($id);
        if(!$Vendor) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'Resource not found.'
            ]);
        }  

        $Vendor->{$field} =  $request->{$field}; 

        if($Vendor->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Vendor updated.',
                'data' => $Vendor
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }

    }


    public function  UpdateResourceIdInOrdersTable(Request $request,$resourceId,$id) {
        if($resourceId !== 'NULL') {
            $resource = Resource::find($resourceId);
            if(!$resource) {
                return response([
                    'code' => 404,
                    'success' => false,
                    'message' => 'Resource not found.'
                ]);
            }
        }


        if($request->data_position) {
            $count = 0;
            foreach($request->data_position as $key => $orderId) {        
                $getCount = $this->updateResourceMultipleOrders($orderId, $resourceId, $id, $request->print_date, $count ); 
                $count = $getCount;                
            }
            
        }else{ 
            $this->updateResourceMultipleOrders($id, null, $id, $request->print_date, null); 
        }

        $id = (int)$id;       

        if($id > 0){  
             $order = Order::leftJoin('order_details','orders.id','=','order_details.order_id')->where('orders.id', $id);
   
             $order = $order->select(['orders.*','order_details.product_group_id'])->first();
            

             if($order->product_group_id != 'null'){  

                $getAllGroupId = OrderDetails::where('product_group_id', $order->product_group_id)->pluck('order_id')->join(', ');
                $order->group_id = $getAllGroupId;

             }


        }
  
       return response([
        'code' => 200,
        'success' => true,
        'message' => 'Resource updated.' ,
        'data' => $order
        ]); 

 /*        if($request->data_position) {
            foreach($request->data_position as $key => $orderId) {               
               
                $orderData = Order::where('id', $orderId)->first();            
                $orderData->sort_by_resource = $key;                
                $orderData->save();
                 
            }
            
        }  
        $id = (int)$id; 

        if($id > 0){
            $order = Order::find($id);
            if(!$order) {
                return response([
                    'code' => 404,
                    'success' => false,
                    'message' => 'Order not found.'
                ]);
            }
    
            
            $order->resource_id = $resourceId;
            $order->print_date = $request->print_date;
     
    
            if($order->update()) {
                return response([
                    'code' => 200,
                    'success' => true,
                    'message' => 'Resource updated.',
                    'data' => $order
                ]);
            } else {
                return response([
                    'code' => 500,
                    'success' => false,
                    'message' => 'Something went wrong, Try again later.'
                ]);
            }

        }else{
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Resource updated.',
            ]);
        }  */


    }

    public function  UpdatePrintersIdInOrdersTable(Request $request, $printerId, $id) {
   
        if($printerId !== 'NULL') {
            $printer = Printer::find($printerId);
            if(!$printer) {
                return response([
                    'code' => 404,
                    'success' => false,
                    'message' => 'Printer not found.'
                ]);
            }  
        }

 
 
       if($request->data_position) {
            $count = 0;
            foreach($request->data_position as $key => $orderId) {        
                $getCount = $this->updatePrinterMultipleOrders($orderId, $printerId, $id, $request->print_date, $count ); 
                $count = $getCount;                
            }
            
        }else{ 
             
            $this->updatePrinterMultipleOrders($id, null, $id, $request->print_date, null); 
        }
 
        $id = (int)$id;       
        $order = "";
        if($id > 0){  
             $order = Order::leftJoin('order_details','orders.id','=','order_details.order_id')->where('orders.id', $id);  
             $order = $order->select(['orders.*','order_details.product_group_id'])->first();
 
           
             if(!is_null($order->product_group_id) ){                 
                $getAllGroupId = OrderDetails::leftJoin('orders','orders.id','=','order_details.order_id')->where('orders.status', 'Production')->where('product_group_id', $order->product_group_id)->pluck('order_id')->join(', ');
                $order->group_id = $getAllGroupId;

             }

             
        }
  
       return response([
        'code' => 200,
        'success' => true,
        'message' => 'Printer updated.' ,
        'data' => $order
        ]); 

    }

    public function updateResourceMultipleOrders($orderId,$resourceId,$id, $print_date, $count){
          
        $query = Order::leftJoin('order_details','orders.id','=','order_details.order_id')->where('orders.id', $orderId);
   
        $query = $query->select(['orders.id',  'orders.sort_by_resource','orders.resource_id','orders.print_date', 'order_details.product_group_id'])->first();
        $isCurrentOrder = false;
        switch($query->product_group_id){
            case ($query->product_group_id != 'null'): 
                $getAllGroupId = OrderDetails::where('product_group_id', $query->product_group_id)->get(['order_id']);
                 
                if($query->id == $id){   
                    $isCurrentOrder = true;
                }
                foreach($getAllGroupId as $i => $order){  
                    $orderData = Order::where('id', $order->order_id)->first(['id','sort_by_resource','resource_id','print_date'  ]);
                    if($resourceId != null) {
                        $orderData->sort_by_resource = $count;
                        $count++; 
                    }
                    else{
                        $orderData->sort_by_resource = null;                       
                    } 
                    $orderData->resource_id  = $resourceId;

                    if($isCurrentOrder){                                
                        $orderData->print_date  = $print_date; 
                    }                            
                   
                    $orderData->save(); 
                }   
                
            break;
            default:
                if($resourceId != null) {
                    $query->sort_by_resource = $count; 
                    $count++; 
                }else{
                    $query->sort_by_resource = null;                       
                }                                     
                if($query->id == $id){
                    $query->resource_id = $resourceId;
                    $query->print_date = $print_date;
               
                }
                 
                $query->save();
            break;       

        } 
        return $count;
    }

    public function updatePrinterMultipleOrders($orderId,$printerId,$id, $print_date, $count){
          
        $query = Order::leftJoin('order_details','orders.id','=','order_details.order_id')->where('orders.id', $orderId);
        $query = $query->select(['orders.id',  'orders.sort_by_printer','orders.printer_id','orders.print_date', 'orders.trader_printer_id','order_details.product_group_id'])->first();
    
        $isCurrentOrder = false;
        switch($this->validate_empty_null($query->product_group_id)){
            case false: 
                $getAllGroupId = OrderDetails::where('product_group_id', $query->product_group_id)->get(['order_id']);
           
                if($query->id == $id){   
                    $isCurrentOrder = true;
                }
                foreach($getAllGroupId as $i => $order){  
                    $orderData = Order::where('id', $order->order_id)->first(['id','sort_by_printer','printer_id','print_date','trader_printer_id' ]);
                    if($printerId != null) {
                        $orderData->sort_by_printer = $count;
                        $count++; 
                    }
                    else{
                        $orderData->sort_by_printer = null;                       
                    } 
                    $orderData->printer_id  = $printerId;

                    if($isCurrentOrder){                                
                        $orderData->print_date  = $print_date;
                        if(auth()->user()->role == 'Admin' && $this->validate_empty_null($printerId) == true && $this->validate_empty_null($query->trader_printer_id) == false) {
                            $orderData->trader_printer_id  = null;
                        }
                    }                            
                   
                    $orderData->save(); 
                }   
                
            break;
            default:
             
                if($printerId != null) {
                    $query->sort_by_printer = $count; 
                    $count++; 
                }else{
                    $query->sort_by_printer = null;                       
                }                 
                                  
                if($query->id == $id){
                  
                    $query->printer_id = $printerId;
                    $query->print_date = $print_date;

                    
                    if(auth()->user()->role == 'Admin' && $this->validate_empty_null($printerId) == true && $this->validate_empty_null($query->trader_printer_id) == false) {
                        $query->trader_printer_id = null;
                    }
                } 
                $query->save();
            break;       

        } 
        return $count;
    }

    public function  UpdatePrintersIdInOrderForTrader(Request $request, $userId, $id) {
  
        if($userId !== 'NULL') {
            $user = User::find($userId);
            if(!$user) {
                return response([
                    'code' => 404,
                    'success' => false,
                    'message' => 'User not found.'
                ]);
            }  
        }

 
 
       if($request->data_position) {
            foreach($request->data_position as $key => $orderId) {               
               
                $orderData = Order::where('id', $orderId)->first();            
                $orderData->sort_by_printer = $key;                
                $orderData->save();
                 
            }
            
        }  
        $id = (int)$id;       

       if($id > 0){

            $order = Order::find($id);
                if(!$order) {
                    return response([
                        'code' => 404,
                        'success' => false,
                        'message' => 'Order not found.'
                    ]);
                }  
        
                    
                $order->trader_printer_id = $userId;
                $order->print_date = $request->print_date; 

                $OrderEmailQueue = OrderEmailQueue::where('order_id', $order->id)->where('email_type', 'ResourceShippingEmailNewlyAssigned')->count();                     
               
                if($OrderEmailQueue == 0){
                    $time = \Carbon\Carbon::now();
                    OrderEmailQueue::updateOrInsert([
                        'order_id' => $order->id,
                        'email_type' => 'ResourceShippingEmailNewlyAssigned',
                        'created_at' => $time,
                        'updated_at' => $time
                    ]);

                } 


                if($order->update()) {

                    $this->sendQueueEmails($order->id);

                    return response([
                        'code' => 200,
                        'success' => true,
                        'message' => 'Printer updated..',
                        'data' => $order
                    ]);
                } else {
                    return response([
                        'code' => 500,
                        'success' => false,
                        'message' => 'Something went wrong, Try again later.'
                    ]);
                }  
        }else{
            return response([
                           'code' => 200,
                           'success' => true, 
                           'message' => 'Printer updated.',
            ]);
       }   

    }
    
    public function  UpdateTraderOrderToAdmin(Request $request, $printerId, $id) {
  
        if($printerId !== 'NULL') {
            $printer = User::find($printerId);
            if(!$printer) {
                return response([
                    'code' => 404,
                    'success' => false,
                    'message' => 'Printer not found.'
                ]);
            }  
        }

 
 
       if($request->data_position) {
            foreach($request->data_position as $key => $orderId) {               
               
                $orderData = Order::where('id', $orderId)->first();            
                $orderData->sort_by_printer = $key;                
                $orderData->save();
                 
            }
            
        }  
        $id = (int)$id;       

       if($id > 0){

            $order = Order::find($id);
                if(!$order) {
                    return response([
                        'code' => 404,
                        'success' => false,
                        'message' => 'Order not found.'
                    ]);
                }  
        
                if($printerId == 'NULL') {
                    $order->resource_admin = null;
                    $order->print_date = null;
                    $order->printer_id = null;  
                }else{
                    $order->resource_admin = $printerId;
                    $order->print_date = $request->print_date; 
                } 

                if($order->update()) {
                    return response([
                        'code' => 200,
                        'success' => true,
                        'message' => 'Printer updated.',
                        'data' => $order
                    ]);
                } else {
                    return response([
                        'code' => 500,
                        'success' => false,
                        'message' => 'Something went wrong, Try again later.'
                    ]);
                }  
        }else{
            return response([
                           'code' => 200,
                           'success' => true,
                           'message' => 'Printer updated.',
            ]);
       }   

    }
     

    public function DeleteResource(Request $request, $id) {

        $resource = Resource::find($id);
        if(!$resource) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'Printer not found.'
            ]);
        }

        $resource->is_deleted = !$resource->is_deleted;
        if($resource->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Printer deleted.'
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }

    public function DeleteVendor(Request $request, $id) {

        $vendor = Vendor::find($id);
        if(!$vendor) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'Vendor not found.'
            ]);
        }

        $vendor->is_deleted = 1; 
        
        if($vendor->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Vendor deleted.'
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }

    public function DeleteResourceShipping(Request $request, $id) {

        $resource = ResourceShipping::find($id);
       
        if(!$resource) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'resource shipping details not found.'
            ]);
        }
 
        if($resource->delete()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Resource shipping deleted.'
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }



    public function GetPrintersList(Request $request) {

        switch(auth()->user()->role){
            case "Admin":
                $printers = Printer::whereIsDeleted(0)->orderBy('title', 'asc')->get();
            break;
            default:
                $printers = Printer::whereIsDeleted(0)->where('printer_created_by', auth()->user()->id)->orderBy('title', 'asc')->get();
            break;       

        }  
        return response([
            'code' => 200,
            'success' => true,
            'message' => 'Printers List.',
            'data' => $printers
        ]);
    }
    public function GetPrintersOrderList(Request $request, $printerId) {
        $query = Order::leftJoin('order_details','orders.id','=','order_details.order_id')->where('printer_id', $printerId)->where('status','Production')->orderBy('sort_by_printer', 'ASC');
   
        $query = $query->select(['orders.*', 'order_details.production_start_date as production_start_date', 'order_details.product_group_id']);

        $getGroupIds = array(); 
        $dataToReturn = $query->paginate(100)->toArray();
        foreach($dataToReturn['data'] as $i => $data){
            if(isset($dataToReturn['data'][$i]['product_group_id'])){
                $getGroupIds[] = $dataToReturn['data'][$i]['product_group_id'];
                $getOrderIds[$dataToReturn['data'][$i]['product_group_id']] = $dataToReturn['data'][$i]['id'];
            }
        } 
        if($getGroupIds){
            $batchOrders = OrderDetails::select('product_group_id', DB::raw('GROUP_CONCAT(order_id  SEPARATOR ", ") as ids'))
            ->leftJoin('orders','orders.id','=','order_details.order_id')   
            ->whereIn('product_group_id', $getGroupIds)
            ->where('orders.status', 'Production')
            ->groupBy('product_group_id')
            ->get();
        } 

        foreach($dataToReturn['data'] as $i => $data){
            if(isset($dataToReturn['data'][$i]['product_group_id'])){
                foreach($batchOrders as $j => $details){
                    $idsArr = explode(',',$details['ids']); 
                    $totalCount = Order::whereIn('id', $idsArr)->get();
                    $total = $totalCount->sum('total_product_count');
                    if($details['product_group_id'] == $dataToReturn['data'][$i]['product_group_id']){
                        $dataToReturn['data'][$i]['group_id'] = $details['ids'];
                        $dataToReturn['data'][$i]['group_total_count'] = $total;
                        foreach($getOrderIds as $getOrderId){
                            if($getOrderId == $dataToReturn['data'][$i]['id']){
                                $filterData[] = $dataToReturn['data'][$i];
                            } 
                        } 
                    }                        
                }
            }else{
                $filterData[] = $dataToReturn['data'][$i];
            }
        }
        $dataToReturn['data'] = $filterData;
        /* 
                $printer = Printer::find($printerId);
                if(!$printer) {
                    return response([
                        'code' => 404,
                        'success' => false,
                        'message' => 'Printer not found.'
                    ]);
                }
                $printer->working_order_id = $dataToReturn['data'][0]['id'];    
                $printer->update();  
        */
               
        return response([
            'code' => 200,
            'success' => true,
            'message' => 'Printer Order List.',
            'data' => $dataToReturn
        ]);
    }

    public function GetPrintersOrderListId(Request $request, $printerId) {
        $today = now()->toDateString();
        $query1 = Order::select('id')->where('printer_id', $printerId)->where('status','Production')->orderBy('sort_by_printer', 'ASC');
        $query2 = Order::select('id')->where('printer_id', $printerId)->where('status','Completed')->whereDate('updated_at', $today);
          
        $union = $query1->union($query2);

        $ids = $union->pluck('id'); 

        $query = Order::select('id','status')->whereIn('id', $ids)->orderBy('sort_by_printer', 'ASC')->get(); 

        return response([
            'code' => 200,
            'success' => true,
            'message' => 'Printer Order List Id.',
            'data' => $query
        ]);
    }


    public function updateWorkingOrderId($printerId, $id) {
 
        
                $printer = Printer::find($printerId);
                if(!$printer) {
                    return response([
                        'code' => 404,
                        'success' => false,
                        'message' => 'Printer not found.'
                    ]);
                }
                $printer->working_order_id = $id;    
                $printer->update();  
        
 
               /*  $timeNow = \Carbon\Carbon::now();

                OrderDetails::updateOrInsert(
                    ['order_id' => $id], ['printing_start_time' => $timeNow],                    
                ); */
               
        return response([
            'code' => 200,
            'success' => true,
            'message' => 'Printer Working Order Id updated.', 
        ]);
    }


    public function CreatePrinter(Request $request) {
        $validator = Validator::make($request->all(), [
            'title' => 'required' 
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $printer = new Printer;

        $printer->title = $request->title;
        $printer->email = $request->email;
        $printer->mobile = $request->mobile;
        $printer->printer_cart_id = $request->printer_cart_id;
        $printer->whoami = Str::random(25);

        $printer->printer_created_by = auth()->user()->id;

        if($request->profile_image != 'undefined') {
             
                $folder = '/printer/profile_image';
                $fileName = Misc::GenerateToken(10).'.'.$request->profile_image->getClientOriginalExtension();                
                $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->profile_image, $fileName, 'public'); 
                $printer->profile_image = env('AWS_URL').$uploadPath;
                $extension = $request->profile_image->getClientOriginalExtension();
                if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                    $thumb_tmp_path="../storage/tmp/". $fileName;
                    $this->resize_crop_image(150,   $request->profile_image, $thumb_tmp_path);
                    $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                    $printer->profile_image = env('AWS_URL') . $uploadThumbnailPath; 
                    unlink($thumb_tmp_path);
                }
             
        } 

        if($request->login_image != 'undefined') {
             
            $folder = '/printer/profile_image';
            $login_image_fileName = Misc::GenerateToken(10).'login.'.$request->login_image->getClientOriginalExtension();                
            $login_image_uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->login_image, $login_image_fileName, 'public'); 
            $printer->login_image = env('AWS_URL').$login_image_uploadPath;
            $login_image_extn = $request->login_image->getClientOriginalExtension();
            if( $login_image_extn === 'jpg' || $login_image_extn === 'jpeg' ||   $login_image_extn === 'png' || $login_image_extn === 'gif' ){
                $login_image_thumb_tmp_path="../storage/tmp/". $login_image_fileName;
                $this->resize_crop_image(150,   $request->login_image, $login_image_thumb_tmp_path);
                $login_image_uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $login_image_thumb_tmp_path, $login_image_fileName, 'public');
                $printer->login_image = env('AWS_URL') . $login_image_uploadThumbnailPath; 
                unlink($login_image_thumb_tmp_path);
            }
         
        } 

        if($printer->save()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Printer Added.',
                'data' => $printer
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }

    }

    public function UpdatePrinter(Request $request, $id) {
        $validator = Validator::make($request->all(), [
            'title' => 'required'
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $printer = Printer::find($id);
        if(!$printer) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'Printer not found.'
            ]);
        }
        $printer->title = $request->title;
        $printer->email = $request->email;
        $printer->mobile = $request->mobile;
        $printer->printer_cart_id = $request->printer_cart_id;
        
        if($printer->whoami == null){            
            $printer->whoami = Str::random(25);
        } 
        
        if($request->profile_image) {
               
             if($request->isImageValid == 'true') {
                $folder = '/printer/profile_image';
                $fileName = Misc::GenerateToken(10).'.'.$request->profile_image->getClientOriginalExtension();
                $extension = $request->profile_image->getClientOriginalExtension();
                $uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->profile_image, $fileName, 'public');
                                
                   
                $printer->profile_image = env('AWS_URL').$uploadPath; 

                if( $extension === 'jpg' || $extension === 'jpeg' ||   $extension === 'png' || $extension === 'gif' ){
                    $thumb_tmp_path="../storage/tmp/". $fileName;
                    $this->resize_crop_image(150,   $request->profile_image, $thumb_tmp_path);
                    $uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $thumb_tmp_path, $fileName, 'public');
                    $printer->profile_image = env('AWS_URL') . $uploadThumbnailPath; 
                    unlink($thumb_tmp_path);
                }
                
             }           
         
        } 


        if($request->login_image != 'undefined') {

                           
            if($request->isLoginImageValid == 'true') {
                $folder = '/printer/profile_image';
                $login_image_fileName = Misc::GenerateToken(10).'login.'.$request->login_image->getClientOriginalExtension();  
                $login_image_extn = $request->login_image->getClientOriginalExtension();
                $login_image_uploadPath = \Storage::disk('s3')->putFileAs($folder, $request->login_image, $login_image_fileName, 'public');
                                
                   
                $printer->login_image = env('AWS_URL').$login_image_uploadPath; 

                if( $login_image_extn === 'jpg' || $login_image_extn === 'jpeg' ||   $login_image_extn === 'png' || $login_image_extn === 'gif' ){
                    $login_image_thumb_tmp_path="../storage/tmp/". $login_image_fileName;
                    $this->resize_crop_image(150,   $request->login_image, $login_image_thumb_tmp_path);
                    $login_image_uploadThumbnailPath = \Storage::disk('s3')->putFileAs($folder .'/thumbnail', $login_image_thumb_tmp_path, $login_image_fileName, 'public');
                    $printer->login_image = env('AWS_URL') . $login_image_uploadThumbnailPath; 
                    unlink($login_image_thumb_tmp_path);
                }
                
             }  
             
 
        } 

        if($printer->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Printer updated.',
                'data' => $printer
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }


    }

    public function UpdatePrinterFaceId(Request $request, $id) {
        $validator = Validator::make($request->all(), [
            'faceId' => 'required'
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $printer = Printer::find($id);
        if(!$printer) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'Printer not found.'
            ]);
        }
        $printer->face_id = $request->faceId;    

        if($printer->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Printer updated.',
                'data' => $printer
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }

    }




    public function DeletePrinter(Request $request, $id) {

        $printer = Printer::find($id);
        if(!$printer) {
            return response([
                'code' => 404,
                'success' => false,
                'message' => 'Printer not found.'
            ]);
        }

        $printer->is_deleted = !$printer->is_deleted;


        if($printer->update()) {
            return response([
                'code' => 200,
                'success' => true,
                'message' => 'Printer deleted.'
            ]);
        } else {
            return response([
                'code' => 500,
                'success' => false,
                'message' => 'Something went wrong, Try again later.'
            ]);
        }
    }


    public function printerBreak(Request $request) {
      
        $validator = Validator::make($request->all(), [
            'type' => 'required' 
        ]);

        if ($validator->fails()) {
            return response([
                'code' => 400,
                'success' => false,
                'message' => Misc::FirstValidationMessage($validator->errors()),
                'errors' => $validator->errors()
            ]);
        }

        $printerId = $request->printer_id;       
        $printer = Printer::find($printerId);
        $today = \Carbon\Carbon::now()->format('Y-m-d');
        $time = \Carbon\Carbon::now()->format('h:i:s');
        $timeNow = \Carbon\Carbon::now()->format('M, d Y @ h:i A');
        if($request->type == 'clock-in'){
            PrinterTimeLog::create([
                'printer_id' => $printerId,
                'date' => $today, 
                'start_time' => $time, 
                'login_type' =>  $request->type
            ]);  

            if($printer->mobile){
                Twilio::message($printer->mobile, 'Break Clock out '.  $timeNow);                        
            }
        }else if ($request->type == 'logout'){
             
            $printerTimeLog = PrinterTimeLog::where('printer_id',$printerId)->where('date',$today)->where('login_type', 'login')->orderBy('id', 'desc')->first();
            $printerTimeLog->end_time = $time;
            $printerTimeLog->logout_type = $request->type;
            $printerTimeLog->update();  
            if($printer->mobile){
                Twilio::message($printer->mobile, 'Clock Out '.  $timeNow);                        
            }
    
        } else{
             
            $printerTimeLog = PrinterTimeLog::where('printer_id',$printerId)->where('date',$today)->where('login_type', 'clock-in')->orderBy('id', 'desc')->first();
            $printerTimeLog->end_time = $time;
            $printerTimeLog->logout_type = $request->type;
            $printerTimeLog->update();  
            if($printer->mobile){
                Twilio::message($printer->mobile, 'Break Clock in '.  $timeNow);                        
            }
    
        } 

    }

    public function updateOrderTrackingDetailWebhook(){

        $inputJSON = file_get_contents("php://input");

        $data = json_decode($inputJSON);
 
        $order = Order::where(['tracking_number' => $data->msg->tracking_number])->first();
        if($order){

            $orderID = $order->id;
        }
        if($order){
            $order->shipping_des = $data->msg->tag;

            if($order->shipping_des === 'Delivered'){

                ActivityNotif::create([
                    'order_id' => $order->id,
                    'title' => 'Order Delivered - ' . $order->id,
                    'description' => $order->name,
                    'initiated_by' => $order->created_by,
                    'action' => 'order_delivered',
                    'type' => 'admin' 
                ]);

                

                try {        

                    /* Label Urls - Start */
                    $labels = PastLabels::where(['order_id' => $orderID, 'type' => 'shipping'])->get();
   
                    $labelUrls = []; 
                    $labelLinks = "";
                    foreach($labels as $i => $label){
   
                        $metadata = json_decode($label->metadata);
                       
                        if(isset($metadata->shipstation)){
        
                            if(@$metadata->shipstation->carrierCode === null){
                                $metadata->shipstation->carrierCode = $metadata->shipstation->carriers_code;
                            }
                            
                            switch(@$metadata->shipstation->carrierCode){
                                case "fedex":
                                    $labelUrls[count($labelUrls)] = 'https://www.fedex.com/fedextrack/?action=track&trackingnumber='.$metadata->tracking_number; 
                                    $labelLinks .=  'https://www.fedex.com/fedextrack/?action=track&trackingnumber='.$metadata->tracking_number.' , '; 
                                break;
                                case "stamps_com":
                                    $labelUrls[count($labelUrls)] = 'https://tools.usps.com/go/TrackConfirmAction.action?tLabels='.$metadata->tracking_number;
                                    $labelLinks .= 'https://tools.usps.com/go/TrackConfirmAction.action?tLabels='.$metadata->tracking_number.' , '; 
                                break;
                                case "ups_walleted":
                                    $labelUrls[count($labelUrls)] = 'http://wwwapps.ups.com/WebTracking/processRequest?HTMLVersion=5.0&Requester=NES&AgreeToTermsAndConditions=yes&loc=en_US&tracknum='.$metadata->tracking_number;
                                    $labelLinks .=   'http://wwwapps.ups.com/WebTracking/processRequest?HTMLVersion=5.0&Requester=NES&AgreeToTermsAndConditions=yes&loc=en_US&tracknum='.$metadata->tracking_number.' , '; 
                                break;
                            }
                            
                          
                        }                
                    }
                    /* Label Urls - End */
                   
                       
                       $sendMailToCreator = User::where(['id' => $order->created_by])->first();
                       $userToSendTo = User::where(['id' => $order->customer_id])->first();
                                          
                       $companyName = "District Printing";
                       if($sendMailToCreator->role == 'Trader'){  
                           Config::set('mail',$this->traderMailConfig($sendMailToCreator));
                           $companyName = $sendMailToCreator->company_name;                  
                       } 
                       $bcc=["notifications@districtprinting.tech"];
                       if($this->isEmptyValue($order->shopify_id) || $this->isEmptyValue($order->etsy_id)){
                            Mail::to($sendMailToCreator->email)->bcc($bcc)->send(new OrderShipmentDelivered($userToSendTo,$order,$labelUrls,$sendMailToCreator ));
                       } else{                       
                            Mail::to($order->customer_email)->cc($sendMailToCreator->email)->bcc($bcc)->send(new OrderShipmentDelivered($userToSendTo,$order,$labelUrls,$sendMailToCreator ));
                       }
                   }catch(\Exception $e){
                       
                   }

                   try {
                    if($order->customer_phone !== '3109169514'){                  
                       
                        Twilio::message($order->customer_phone, 'Your order  has been Delivered. Please check link for updates - '. $companyName.'. Tracking Link: ' .  $labelLinks );
                    }
                    }catch(\Exception $e){
                    }
   

            }

            $order->update();
    
            OrderMeta::updateOrInsert(['order_id' => $order->id],['aftership_data' => $inputJSON]);
            /* return $labelLinks; */
            return $order;
        }else{
            return "Order Not Found";
        } 
    }

    public function addTrackingNumberInAfterShip($id){        
        
        $guzzle = new Guzzle\Client([
            'base_uri' => 'https://api.aftership.com/v4/',
            'headers' => [ 
                'as-api-key' => env('AFTERSHIP_DEFAULT'),
                'Content-Type' => 'application/json'
            ]
        ]); 

        $order = OrderMeta::where('order_id', $id)->first();    

            foreach($order->purchasing_tracking['data'] as $key => $trackingNumber){
                
                if($trackingNumber){
                    
                    try{

                        $tracking = $guzzle->get('trackings?keyword='.$trackingNumber); 
                        
                        $trackingDetailsResults = json_decode($tracking->getBody()->getContents());   
                       
                        $isNewTrackingNumber = false;
                        if(!$trackingDetailsResults->data->trackings) {
                                
                            $guzzle->post('trackings', [
                                'body' => json_encode(['tracking' => [
                                    'tracking_number' => $trackingNumber
                                ]])
                            ]);  

                        } 
                    
                    } catch(\Exception $e){
                        
                    }
                }
                
              
            } 
          
    }

    public function traderMailConfig($sendMailToCreator) {
       /*  $config = array(
            'driver'     => $sendMailToCreator->trader_transport,
            'host'       => $sendMailToCreator->trader_host,
            'port'       => $sendMailToCreator->trader_port,
            'from'       => array('address' => $sendMailToCreator->trader_email, 'name' => $sendMailToCreator->company_name),
            'encryption' => $sendMailToCreator->trader_encryp,
            'username'   => $sendMailToCreator->trader_username,
            'password'   => $sendMailToCreator->trader_password, 
        );   */
        $config = array(
            'driver'     => env('STORE_MAIL_MAILER'),
            'host'       => env('STORE_MAIL_HOST'),
            'port'       => env('STORE_MAIL_PORT'),
            'from'       => array('address' => 'orders@shopupdates.store', 'name' => $sendMailToCreator->company_name),
            'encryption' => env('STORE_MAIL_ENCRYPTION'),
            'username'   => env('STORE_MAIL_USERNAME'),
            'password'   => env('STORE_MAIL_PASSWORD'),
        ); 
        return $config;
    }


    public function sendVendorPlacingOrderEmail($order, $bcc) {
     
         
         foreach([1,2,3,4,5] as $i){ 
           
            $vendor  = $order['product_apparel_source_'.$i];
            $orderInfo =  $order;
            
            if(isset($vendor)){
                if($vendor != 'provided' && $vendor != 'inventory' && $vendor != 'apparel_others'){

                    if($vendor == 's_and_s'){
                        $vendor = 'S&S Activewear';
                    } 
                  
                    $vendorDetail = Vendor::where('vendor_name', $vendor)->whereIsDeleted(0)->first();

                    
                    $orderArray[$vendorDetail['vendor_name']]['id'] =  $orderInfo['id'];
                    $orderArray[$vendorDetail['vendor_name']]['name'] =  $vendorDetail['vendor_name'];
                    $orderArray[$vendorDetail['vendor_name']]['email'] =  $vendorDetail['email'];
                    $orderArray[$vendorDetail['vendor_name']]['needToSendEmail'] =  $vendorDetail['is_email'];
                    $orderArray[$vendorDetail['vendor_name']]['sms'] =  $vendorDetail['vendor_sms'];
                    $orderArray[$vendorDetail['vendor_name']]['needToSendSms'] =  $vendorDetail['is_call'];
                  
                   
                    if($orderInfo['item_number_'.$i] != null){
                        $orderArray[$vendor]['order-details'][$i]['Item'] = $orderInfo['item_number_'.$i];
                    } 
                    if($orderInfo['product_color_'.$i] != null){
                        $orderArray[$vendor]['order-details'][$i]['Color'] = $orderInfo['product_color_'.$i];
                    }
                    if($orderInfo['brand_name'.$i] != null){                            
                        $orderArray[$vendor]['order-details'][$i]['Brand'] = $orderInfo['brand_name'.$i];
                    } 
                    if($this->nullFilter($orderInfo['xs_'.$i])){
                        $orderArray[$vendor]['order-details'][$i]['size']['XS'] = $this->nullFilter($orderInfo['xs_'.$i]); }
                    if($this->nullFilter($orderInfo['s_'.$i])){
                        $orderArray[$vendor]['order-details'][$i]['size']['S'] = $this->nullFilter($orderInfo['s_'.$i]); }
                    if($this->nullFilter($orderInfo['m_'.$i])){
                        $orderArray[$vendor]['order-details'][$i]['size']['M'] = $this->nullFilter($orderInfo['m_'.$i]); }
                    if($this->nullFilter($orderInfo['l_'.$i])){
                        $orderArray[$vendor]['order-details'][$i]['size']['L'] = $this->nullFilter($orderInfo['l_'.$i]);}
                    if($this->nullFilter($orderInfo['xl_'.$i])){
                        $orderArray[$vendor]['order-details'][$i]['size']['XL'] = $this->nullFilter($orderInfo['xl_'.$i]);}
                    if($this->nullFilter($orderInfo['xxl_'.$i])){
                        $orderArray[$vendor]['order-details'][$i]['size']['XXL'] = $this->nullFilter($orderInfo['xxl_'.$i]);}
                    if($this->nullFilter($orderInfo['xxxl_'.$i])){
                        $orderArray[$vendor]['order-details'][$i]['size']['XXXL'] = $this->nullFilter($orderInfo['xxxl_'.$i]);}
                    if($this->nullFilter($orderInfo['other_size_text_1_'.$i])){
                        $orderArray[$vendor]['order-details'][$i]['size']['@othersize@'.$orderInfo['other_size_1_'.$i]] = $this->nullFilter($orderInfo['other_size_text_1_'.$i]);
                    }
                    if($this->nullFilter($orderInfo['other_size_text_2_'.$i])){
                        $orderArray[$vendor]['order-details'][$i]['size']['@othersize@'.$orderInfo['other_size_2_'.$i]] = $this->nullFilter($orderInfo['other_size_text_2_'.$i]);
                    }
                    if($this->nullFilter($orderInfo['other_size_text_3_'.$i])){
                        $orderArray[$vendor]['order-details'][$i]['size']['@othersize@'.$orderInfo['other_size_3_'.$i]] = $this->nullFilter($orderInfo['other_size_text_3_'.$i]);
                    }
                    if($this->nullFilter($orderInfo['other_size_text_4_'.$i])){
                        $orderArray[$vendor]['order-details'][$i]['size']['@othersize@'.$orderInfo['other_size_4_'.$i]] = $this->nullFilter($orderInfo['other_size_text_4_'.$i]);
                    }   
                    $totalCount = $this->nullFilter($orderInfo['xs_'.$i])
                                                                        + $this->nullFilter($orderInfo['s_'.$i])
                                                                        + $this->nullFilter($orderInfo['m_'.$i])
                                                                        + $this->nullFilter($orderInfo['l_'.$i])
                                                                        + $this->nullFilter($orderInfo['xl_'.$i])
                                                                        + $this->nullFilter($orderInfo['xxl_'.$i])
                                                                        + $this->nullFilter($orderInfo['xxxl_'.$i])
                                                                        + $this->nullFilter($orderInfo['other_size_text_1_'.$i])
                                                                        + $this->nullFilter($orderInfo['other_size_text_2_'.$i])
                                                                        + $this->nullFilter($orderInfo['other_size_text_3_'.$i])
                                                                        + $this->nullFilter($orderInfo['other_size_text_4_'.$i]);

                    if($totalCount){
                        $orderArray[$vendor]['order-details'][$i]['Total Count'] = $totalCount;
                       
                    }
                    
                    $itemsQty = array_column($orderArray[$vendor]['order-details'], 'Total Count');
                    $orderArray[$vendorDetail['vendor_name']]['total'] = array_sum($itemsQty);
                }
             
            }

        }
        
        if(isset($orderArray)){         
            foreach ($orderArray as   $order){ 
            if($order['needToSendEmail'] == 'true') {
                    Mail::to($order['email'])->cc('purchasing@districtprinting.tech')->bcc($bcc)->send(new VendorOrderPlacementMail($order));     
                
                }
            if($order['needToSendSms'] == 'true') {
                Twilio::message($order['sms'], 'Order for '.$order['total'].' pcs,  district Printing (#'.$order['id'].') sent via email. Please check and let us know when ready for pickup

    ');  
            }
            }
        }

     
    }

    
    public function nullFilter($text){ 

        $value = null;
        if (!empty($text)) {                   
                $value = $text;
        }
        return $value;

    }

    public function validate_empty_null($value) {
        // Check if the value is empty (empty string or no value)
        $returnValue = false;
        if (empty($value)) {
            $returnValue = true;
        }
      
        // Check if the value is null
        if (is_null($value)) {
            $returnValue = true;
        }
      
        // Check if the value is "NULL" (string)
        if (strtoupper($value) === "NULL") { 
            $returnValue = true;
        }
      
        // If none of the above conditions are met, the value is valid
        return $returnValue; 
      }


    
}